define(['jquery','httprequest','bootstrap-dialog','mock-request'],
function($,httprequest,BootstrapDialog,mockRequest){
	MockUri ={
			currentUri:{},
			
	};
	
	MockUri.showUrlByProjectId = function(projectId){
		MockUri.projectId = projectId;
		
		var treehigh = $(window).height() -190;
		
		var div_content ="";
		div_content +="<div class='col-md-3' id='content-left'>";
		div_content +="	<div id ='d-mul' class='alert alert-warning' role='alert'></div>";
		div_content +="	<div id ='tree' class='fix-scoll-high'></div>";
		div_content +="</div>";
		div_content +="<div id='content-right'  class='col-md-9'></div>";
		$("#content").html(div_content)
		
		$('#tree').css('height',treehigh+'px');
		
		var tree = [];
		$('#tree').treeview({data:tree});
		httprequest.send({
			type : "GET",
			url : "/mock/uri/project/" + projectId,
			dataType:"json",
			success : function(obj,status) {
				var entity = obj.entity;
				if (entity.status == 200) {
					for (var i = 0; i < entity.data.length; i++) {
						tree.push({
							mockUriId		:	entity.data[i].id,
							text			:	entity.data[i].mockUriName,
							mockUri			:	entity.data[i].mockUri,
							mockMethod		:	entity.data[i].mockMethod,
							mockIsRun		:	entity.data[i].isRun,
						});
					}
					$('#tree').treeview({
						data: tree,
						onNodeSelected:function(event,node){
							if(event.type === "nodeSelected"){
								$("#btnEditMul").attr("currentMockUriId",node.mockUriId)
								
								MockUri.currentUri = node;
								mockRequest.showMockRequestByUri(projectId,node.mockUriId,node.text,node.mockUri,node.mockMethod,node.mockIsRun);
								//showMockUrlDetail(node.mockUriId,node.text);
							}
						}
					});
				}
			}
		});
			
			var mops ="";
			mops +="<div class='row'>";
			mops +="	<div class='col-md-3'><a title='为当前MOCK系统新增 URI' id='a-createmul' href='javascript:void(0)' class='btn btn-info'><span class='glyphicon glyphicon-plus'>MURL</span></a></div>"; 
			mops +="</div>";
			
			$('#d-mul').html(mops );
		
			$("#a-createmul").on('click',function(){
				MockUri.createUri(projectId);
			});
	}
	
	MockUri.createUri=function(projectId){
		 BootstrapDialog.show({
//	            size: BootstrapDialog.SIZE_WIDE,
	            title:"新增MOCK URI",
	            message: uriDemo("",projectId,"","","",""),
	            closable: true,
	            closeByBackdrop: false,
	            closeByKeyboard: false,
	            buttons: [{
	                label: '确定',
	                cssClass: 'btn-primary',
	                action: function(dialog){
	            		saveUri("insert",dialog);
	                }
	            }, {
	                label: '取消',
	                action: function(dialog){
	            		dialog.close();
	                }
	            }],
	            
	        });
	}
	
	
	MockUri.editUri=function(projectId){
		uri = MockUri.currentUri;
				 BootstrapDialog.show({
		//	            size: BootstrapDialog.SIZE_WIDE,
			            title:"修改MOCK URI",
			            message: uriDemo(uri.mockUriId,projectId,uri.text,uri.mockMethod,uri.mockIsRun,uri.mockUri),
			            closable: true,
			            closeByBackdrop: false,
			            closeByKeyboard: false,
			            buttons: [{
			                label: '确定',
			                cssClass: 'btn-primary',
			                action: function(dialog){
			            		saveUri("update",dialog)
			                }
			            }, {
			                label: '取消',
			                action: function(dialog){
			            	dialog.close();
			                }
			            }]
			        });
	}
	
	
	MockUri.deleteUri=function(uriId){
		var a=confirm("确认删除？");
		 if(a==false){
			 return;
		 }
		var URL = "/mock/uri";
		httprequest.send({
			type : "DELETE",
			url : URL,	
			contentType:'json',
			dataType:'json',
			data : {id:uriId},
			success : function(obj,status) {
				var entity = obj.entity;
				var status = entity.status;
				if (status == "201" || status == "200") {
					MockUri.showUrlByProjectId(MockUri.projectId);
					BootstrapDialog.alert("删除成功！");

				} else {
					BootstrapDialog.alert(obj.message)
				}
			}
		});	
	}
	
	function saveUri(SaveOrUpdate,dialog) {
		var type = SaveOrUpdate == "insert" ? "POST" : "PUT";
		var uri = {};
		if (type == "PUT") {
			uri.id = $('#tUriId').val();
		}
		uri.mockProjectId = $('#tUriProjectId').val();
		uri.mockUriName = $('#tUriName').val();
		uri.mockUri = $('#tUriPath').val();
		uri.mockMethod = $('#tUriMethod').val();
		uri.isRun = $('#tIsRun').val();
		
		dialog.close();
		httprequest.send({
			type : type,
			url : "/mock/uri",
			contentType:'json',
			dataType:'json',
			data : uri,		
			success : function(obj,status) {
				var entity = obj.entity;
				var status = entity.status;
				if (status == "201" || status == "200") {
					MockUri.showUrlByProjectId(uri.mockProjectId);
					BootstrapDialog.alert("操作成功！");
				} else {
					BootstrapDialog.alert("操作失败");
				}
			}
		});
	}
	
	function uriDemo(uriId,uriPorjectId,uriName,uriMethod,uriStatus,uriPath){
		var runCss = uriStatus === "RUN" ? "selected" :"";
		var stopCss = uriStatus === "STOP" ? "selected" :"";
		var table = "";
		table += "<table class='table'>";
		table += "<tr>";
		table += "<td > 接口名：</td>";
		table += "<td colspan='3'> ";
		table += "<input type='hidden' id='tUriId' value='"+uriId+"'  >";
		table += "<input type='hidden' id='tUriProjectId' value='"+uriPorjectId+"'  >";
		table += "<input type='text' id='tUriName' value='"+uriName+"'  >";
		table += "</td>";
		table += "</tr>";
		table += "<tr>";
		table += "<td > Method： </td >";
		table += "<td >";
		table += "<input type='text' id='tUriMethod' value='"+uriMethod+"' >";
		table += "</td>";
		table += "<td > 状态： </td >";
		table += "<td>";
		table += "<select id='tIsRun' class='wt100'>";	
		table += "<option id='IsRunRUN' value='RUN' "+runCss+">启用</option>";
		table += "<option id='IsRunSTOP' value='STOP' "+stopCss+">停用</option>";
		table += "</select>";
		table += "</td></tr>";
		table += "<tr>";
		table += "<td > URI：</td>";
		table += "<td colspan='3'>";
		table += "<input type='text' id='tUriPath' value='"+uriPath+"' ></td>";
		table += "</tr>";
		table += "</table>";
		
		return table
	}

	
	return MockUri;
	
});