define(['jquery','require','httprequest','bootstrap-dialog','mock-callback'],
function($,require,httprequest,BootstrapDialog,mockCallback){
	
	var MockRequest = {
			uri			:	{},
			data		:	[],
		
	};
	MockRequest.showMockRequestByUri = function (projectId,uriId,uriName,uriUrl,uriMethod,uriStatus){
		
		MockRequest.uri.projectId =projectId;
		MockRequest.uri.uriId =uriId;
		MockRequest.uri.uriName =uriName;
		MockRequest.uri.uriUrl =uriUrl;
		MockRequest.uri.uriMethod =uriMethod;
		MockRequest.uri.uriStatus =uriStatus;
		
		var div_content ="";
		div_content +="		<div class='row'>";
		div_content +="			<div class='alert alert-success col-md-12' role='alert'>";
		div_content +="				<div class='col-md-4' ><span class='glyphicon glyphicon-record'></span><span class='glyphicon glyphicon-chevron-right'></span><span id ='uriName'  >uriName</span></div>";
		div_content +="				<div class='col-md-3' ><span id ='uriUrl' >uriUrl</span></div>";
		div_content +="				<div class='col-md-1' ><strong><span id ='uriMethod' >uriMethod</span></strong></div>";
		div_content +="				<div class='col-md-1' ><strong><span id ='uriStatus' >uriStatus</span></strong></div>";
		div_content +="				<div class='col-md-3' >";
		div_content +="					<a title ='编辑当前 Mock URI' id='a-edit"+uriId+"' reid ='"+uriId+"'class='btn btn-primary' href='#'><span class='glyphicon glyphicon-cog'></span></a>";
		div_content +="					<a title ='删除当前 Mock URI'id='a-delete"+uriId+"' reid ='"+uriId+"' class='btn btn-primary' href='#'><span class='glyphicon glyphicon-minus'></span></a>";
		div_content +="					<a title ='为当前 Mock URI 添加请求策略' id='createReauest' class='btn btn-primary' href='#'><span class='glyphicon glyphicon-plus'>策略</span></a>";
		div_content +="				</div>";
		div_content +="			</div>";
		div_content +="		</div>";
		div_content +="		<div class='row' ><ul id='requestsUl' class='list-group' ></ul></div>";
		
		$("#content-right").html(div_content);

		$("#uriName").html(uriName );
		$("#uriUrl").html(uriUrl );
		$("#uriMethod").html(uriMethod );
		$("#uriStatus").html(uriStatus);
		
		$("#a-edit"+uriId).on("click",function(){
			require('mock-uri').editUri(MockRequest.uri.projectId);
			});
		
		$("#a-delete"+uriId).on("click",function(){
			var id = $(this).attr("reid");
			require('mock-uri').deleteUri(id);
		});
		
		$("#createReauest").on("click",function(){MockRequest.createRequest();});
		
		httprequest.send({
			type : "GET",
			url : "/mock/request/uri/" + uriId,
			dataType:"json",
			success : function(obj,status) {
				$("#requestsUl").html("");
				var entity = obj.entity;
				if (entity.status == 200) {
					MockRequest.data = entity.data;
					for (var i = 0; i < entity.data.length; i++) {
						var request = entity.data[i];
						var li = "<li class='list-group-item'>";
						li += "	<div class='row'>";
						li += "		<div class='col-md-4'>";
						li += "			<span class='glyphicon glyphicon-share-alt'>"+request.mockRequestName+"</span>";
						li += "		</div>";
						li += "		<div class='col-md-1'>";
						li += "			<p>"+request.type+"</p>";
						li += "		</div>";
						li += "		<div class='col-md-1'>";
						li += "			<p>"+request.isRun+"</p>";
						li += "		</div>";
						li += "		<div class='col-md-3'>";
						li += "			<p>"+request.updateTime+"</p>";
						li += "		</div>";
						li += "		<div class='col-md-3'>";
						li += "			<div class='row'>";
						li += "				<a title='编辑当前请求策略' id='a-edit"+request.id+"' reid ='"+request.id+"'class='btn btn-primary' href='#'><span class='glyphicon glyphicon-cog'></span></a>";
						li += "				<a title='删除当前请求策略' id='a-delete"+request.id+"' reid ='"+request.id+"' class='btn btn-primary' href='#'><span class='glyphicon glyphicon-minus'></span></a>";
						li += "				<a title='查看当前策略回调列表'id='a-cbl"+request.id+"' reid ='"+request.id+"' class='btn btn-info' href='#'>回调列表 </a>";
						li += "			</div>";
						li += "		</div>";
						li += "	</div>";
						li += "	<div id='d-cbl"+request.id+"' style='display: none' class='row'>";
						li += "		<div class='row'>";
						li += "			<div class='col-md-1'></div>";
						li += "			<div class='col-md-10 alert alert-info' >";
						li += "				<div class='col-md-1'><a id='a-createcallback"+request.id+"' reid ='"+request.id+"' class='btn btn-warning' href='#'><span class='glyphicon glyphicon-plus'></span></a></div>";				
						li += "				<div class='col-md-11'>";				
						li += "				<ul id='Ul-cb"+request.id+"' class='list-group'><li class='list-group-item'>no rows</li><ul>";
						li += "				</div>";
						li += "			</div>";
						li += "		</div>";
						li += "	</div>";
						li += "</li>";
						$("#requestsUl").append(li);
						
						$("#a-cbl"+request.id).on('click',function(){
							var reid = $(this).attr('reid')
							if($("#d-cbl"+reid).css("display") === "block"){
								$("#d-cbl"+reid).hide();
								$("#Ul-cb"+reid).html("");
							} else {
								mockCallback.getCallbackByRequest(reid,"Ul-cb"+reid);
								$("#d-cbl"+reid).show();
							}
						});
						
						$('#a-edit'+request.id).on("click",function(){
							var id = $(this).attr("reid");
							var redata = getRequest(id);
							if(redata.id != undefined){
								MockRequest.editRequest(redata);
							}
						});
						
						$('#a-delete'+request.id).on("click",function(){
							var id = $(this).attr("reid");
							MockRequest.deleteRequest(id);
						});
						
						$("#a-createcallback"+request.id).on("click",function(){
							var id = $(this).attr("reid");
							mockCallback.createCallback(id);
							
						});
					
					}
				}
			}
		});
	};
	
	
	MockRequest.createRequest = function(){
		
		 BootstrapDialog.show({
	            size: BootstrapDialog.SIZE_WIDE,
	            title:"新增策略",
	            message: requestDemo("",MockRequest.uri.uriId,"","0","","","0","0","",""),
	            closable: true,
	            closeByBackdrop: false,
	            closeByKeyboard: false,
	            buttons: [{
	                label: '确定',
	                cssClass: 'btn-primary',
	                action: function(dialog){
		            	saveRequest("insert",dialog)
	            		
	                }
	            }, {
	                label: '取消',
	                action: function(dialog){
	            		dialog.close();
	                }
	            }]
	        });
	}
	
	
	MockRequest.editRequest = function(data){
		 BootstrapDialog.show({
	            size: BootstrapDialog.SIZE_WIDE,
	            title:"修改策略",
	            message: requestDemo(data.id,data.mockUriId,data.mockRequestName,data.orderNum,data.type,data.isRun,data.requestWait,data.responseWait,data.varifyExpect,data.responseExpect),
	            closable: true,
	            closeByBackdrop: false,
	            closeByKeyboard: false,
	            buttons: [{
	                label: '确定',
	                cssClass: 'btn-primary',
	                action: function(dialog){
		            	saveRequest("update",dialog)
	            		
	                }
	            }, {
	                label: '取消',
	                action: function(dialog){
	            		dialog.close();
	                }
	            }],
	            onshown : function(){
			 		$("#varifyExpect").val(data.varifyExpect);
			 		$("#responseExpect").val(data.responseExpect);
			 		 
		 		}
	        });
	}
	
	MockRequest.deleteRequest = function(id){
		var a=confirm("确认删除？");
		 if(a==false){
			 return;
		 }
		httprequest.send({
			type : "DELETE",
			url : "/mock/request",		
			contentType:'json',
			dataType:'json',
			data : {id:id},
			success : function(obj,status) {
				var entity = obj.entity;
				var status = entity.status;
				if (status == "201" || status == "200") {
					var uri = MockRequest.uri;
					BootstrapDialog.alert("操作成功！");
					MockRequest.showMockRequestByUri(uri.projectId,uri.uriId,uri.uriName,uri.uriUrl,uri.uriMethod,uri.uriStatus);

				} else {
					BootstrapDialog.alert("操作失败");
				}
			}
		});	
	}
	
	
	function getRequest(id){
		for(var i=0; i<MockRequest.data.length ;i++){
			var data = MockRequest.data[i];
			if(data.id === id){
				return data;
			}
		}
		return {};
	}
	
	function saveRequest(SaveOrUpdate,dialog) {
		var type = SaveOrUpdate == "insert" ? "POST" : "PUT";
		
		var request = {};
		if (type == "PUT") {
			request.id = $('#ReqId').val();
		}
		request.mockUriId = $('#MockUriId').val();
		request.mockRequestName = $('#MockReqName').val();
		request.responseWait = $('#ReqWait').val();
		request.varifyExpect = $('#varifyExpect').val();
		request.responseExpect = $('#responseExpect').val();
		request.type = $('#type').val();
		request.orderNum = $('#OrderNum').val();
		request.isRun = $('#isRun').val();
		request.requestWait = $('#ReqWait').val();
		request.responseWait = $('#ResWait').val();
		
		dialog.close();	
		
		httprequest.send({
			type : type,
			url :  "/mock/request",
			contentType:'json',
			dataType:'json',
			data : request,
			success : function(obj,status) {
				var entity = obj.entity;
				var status = entity.status;
				if (status == "201" || status == "200") {
					var uri = MockRequest.uri;
					BootstrapDialog.alert("操作成功！");
					MockRequest.showMockRequestByUri(uri.projectId,uri.uriId,uri.uriName,uri.uriUrl,uri.uriMethod,uri.uriStatus);

				} else {
					BootstrapDialog.alert("操作失败");
				}
			}
		});
	}
	
	function requestDemo(ReqId,MockUriId,MockReqName,orderNum,type,isRun,ReqWait,ResWait,varifyExpect,responseExpect){
		var fdSelected = type === "FD" ? "selected" : ""; 
		var bdSelected = type === "BD" ? "selected" : "";
		
		var runStatus =  isRun === "RUN" ? "selected" : "";
		var stopStatus =  isRun === "STOP" ? "selected" : "";
		
		var table = "";
		table += "<table class='table'>";
		table += "<tr>";
		table += "<td colspan='4'>";
		table += "策略名称：";	
		table += "<input type='hidden' id='ReqId' value='"+ReqId+"'  >";
		table += "<input type='hidden' id='MockUriId' value='"+MockUriId+"'  >";
		table += "<input type='text' id='MockReqName' value='"+MockReqName+"'  class='wt300'>";
		table += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;顺序：&nbsp;&nbsp;&nbsp;&nbsp;<input type='text' id='OrderNum' value='"+orderNum+"'  class='wt50'>"
		table += "</td >";
		table += "</tr>";
		table += "<tr>";
		table += "<td colspan='4'>";
		table += "";
		table += "</td>";
		table += "</tr>";
		table += "<tr>";
		table += "<td >";
		table += "类型：";
		table += "</td >";
		table += "<td >";
		table += "<select id='type'  class='wt100'>";	
		table += "<option id='typeFD' value='FD' "+fdSelected+">正向</option>";
		table += "<option id='typeBD' value='BD' "+bdSelected+">反向</option>";
		table += "</select>";
		table += "</td>";	
		table += "<td>状态</td>";
		table += "<td>";
		table += "<select id='isRun'  class='wt100'>";	
		table += "<option id='isRunRUN' value='RUN' "+runStatus+">启用</option>";
		table += "<option id='isRunSTOP' value='STOP' "+stopStatus+">停用</option>";
		table += "</select>";
		table += "</td></tr>";
		table += "<tr>";
		table += "<tr>";
		table += "<td>";
		table += "请求等待时间：";
		table += "</td >";
		table += "<td>";
		table += "<input type='text' id='ReqWait' value='"+ReqWait+"' class='wt50'>";
		table += "</td >";
		table += "<td >";
		table += "响应等待时间：";
		table += "</td >";
		table += "<td >";
		table += "<input type='text' id='ResWait' value='"+ResWait+"'  class='wt50' >";
		table += "</td >";
		table += "</tr>";
		table += "<tr>";
		table += "<td colspan='4'>";
		table += "";
		table += "预期验证JS：&nbsp;&nbsp;<a href='/demo/verifyJsDemo.html' target='_blank'>Demo</a>";
		table += "</td >";
		table += "</tr>";
		table += "<tr>";
		table += "<td colspan='4'>";
		table += "<textarea id='varifyExpect' spellcheck='false' style='margin: 0px; width: 850px; height: 200px;'></textarea>";
		table += "</td>";
		table += "</tr>";
		table += "<tr>";
		table += "<td colspan='4'>";
		table += "";
		table += "预期响应JS：&nbsp;&nbsp;<a href='/demo/ExpectJsDemo.html' target='_blank'>Demo</a>";
		table += "</td >";
		table += "</tr>";
		table += "<tr>";
		table += "<td  colspan='4'>";
		table += "<textarea id='responseExpect' spellcheck='false' style='margin: 0px; width: 850px; height: 200px;'></textarea>";
		table += "</td>";
		table += "</tr>";
		table += "</table>";
		return table;
	}
	
	return MockRequest;
});