/*
 * Decompiled with CFR 0.152.
 */
package com.custom.httprequest.service;

import com.custom.httprequest.Cookie;
import com.custom.httprequest.Header;
import com.custom.httprequest.RequestContent;
import com.custom.httprequest.ResponseContent;
import com.custom.httprequest.connector.HttpRequest;
import com.custom.httprequest.http.HttpCookie;
import com.custom.httprequest.http.HttpHeader;
import com.custom.httprequest.http.request.content.HttpGetContent;
import com.custom.httprequest.http.request.content.item.HttpFileEntity;
import com.custom.httprequest.http.response.HttpResponseEntity;
import com.custom.httprequest.util.HttpResponseUtil;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestREST {
    static Logger log = LoggerFactory.getLogger(RequestREST.class);
    private String domain = "";
    private String url = "";
    private String method = "";
    private HttpHeader header = new HttpHeader();
    private HttpCookie cookie = new HttpCookie();
    private boolean followRedirects = true;
    private HttpRequest _REQUEST = null;
    private RequestContent request = null;
    private ResponseContent response = new HttpResponseEntity();

    public RequestREST() {
    }

    public RequestREST(String domain, String url, String method) {
        this(domain, url, method, null, null, null);
    }

    public RequestREST(String domain, String url, String method, HttpHeader header, HttpCookie cookie) {
        this(domain, url, method, header, cookie, null);
    }

    public RequestREST(String domain, String url, String method, HttpHeader hedaer, HttpCookie cookie, RequestContent contentRequest) {
        this.setDomain(domain);
        this.setUrl(url);
        this.setMethod(method);
        this.setHeader(this.header);
        this.setCookie(cookie);
        this.setContentRequest(contentRequest);
    }

    public RequestREST setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public RequestREST setUrl(String url) {
        this.url = url;
        return this;
    }

    public RequestREST setMethod(String method) {
        this.method = method.toUpperCase();
        return this;
    }

    public RequestREST setHeader(String key, String value) {
        this.header.put(key, value);
        return this;
    }

    public RequestREST setHeader(Header header) {
        this.header.set(header);
        return this;
    }

    public RequestREST setCookie(String key, String value) {
        this.cookie.put(key, value);
        return this;
    }

    public RequestREST setCookie(Cookie cookie) {
        this.cookie.set(cookie);
        return this;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public RequestREST setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public RequestREST setContentRequest(RequestContent request) {
        this.request = request;
        return this;
    }

    public RequestContent getRequest() {
        return this.request;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpHeader getHeader() {
        return this.header;
    }

    public HttpCookie getCookie() {
        return this.cookie;
    }

    public ResponseContent getResponse() {
        return this.response;
    }

    public RequestREST send() throws Exception {
        if (this.method.equals("GET") && this.request != null && this.request instanceof HttpGetContent) {
            HttpGetContent requestGet = (HttpGetContent)this.request;
            this._REQUEST = HttpRequest.get((CharSequence)(this.domain + this.url), (Map)this.request.getContentData(), requestGet.isEncode());
        } else {
            this._REQUEST = new HttpRequest(this.domain + this.url, this.method);
        }
        this._REQUEST.followRedirects(true);
        this.configCerts();
        this.execute();
        return this;
    }

    private void configCerts() {
        if (this.domain.startsWith("https://")) {
            this._REQUEST.trustAllCerts();
            this._REQUEST.trustAllHosts();
        }
    }

    private void execute() throws Exception {
        try {
            log.info("HTTP REQUEST {} {}", (Object)this._REQUEST.method(), (Object)this._REQUEST.url().toString());
            if (this.header != null) {
                log.info("HTTP REQUEST HEADERS << {}", this.header.getData());
                this._REQUEST.headers(this.header.getData());
            }
            if (this.cookie != null) {
                log.info("HTTP REQUEST COOKIES << {}", this.cookie.getData());
                this._REQUEST.headers(this.cookie.getData());
            }
            if (this.request != null) {
                log.info("HTTP REQUEST CONTENT << {}", this.request.getContentData());
                String contentType = this.request.getContentType();
                log.info("HTTP REQUEST Content-Type << {}", (Object)contentType);
                if (contentType.equals("application/x-www-form-urlencoded")) {
                    this._REQUEST.form((Map)this.request.getContentData());
                } else if (contentType.equals("multipart/form-data")) {
                    Map uploadForm = (Map)this.request.getContentData();
                    for (Map.Entry entry1 : uploadForm.entrySet()) {
                        Object value = entry1.getValue();
                        if (value instanceof HttpFileEntity) {
                            HttpFileEntity requestFile = (HttpFileEntity)value;
                            File file = new File(requestFile.getFilePath());
                            this._REQUEST.part((String)entry1.getKey(), requestFile.getName(), requestFile.getType(), file);
                            continue;
                        }
                        this._REQUEST.part((String)entry1.getKey(), (String)value);
                    }
                } else if (contentType.equals("application/json")) {
                    String bodycontent = (String)this.request.getContentData();
                    if (this.request.getCharset() != null) {
                        this._REQUEST.send(bodycontent.getBytes(this.request.getCharset().toUpperCase()));
                    } else {
                        this._REQUEST.send(bodycontent.getBytes());
                    }
                } else if (contentType.equals("application/xml")) {
                    String bodycontent = (String)this.request.getContentData();
                    if (this.request.getCharset() != null) {
                        this._REQUEST.send(bodycontent.getBytes(this.request.getCharset().toUpperCase()));
                    } else {
                        this._REQUEST.send(bodycontent.getBytes());
                    }
                }
            }
            HttpResponseUtil.parseResponse(this.response, this._REQUEST);
            log.info("HTTP REQUEST {} {}{} ,RESPONSE status line :{} {} ", new Object[]{this.method, this.domain, this.url, this.response.getStatus(), this.response.getReason()});
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            throw e;
        }
    }
}

