/*
 * Decompiled with CFR 0.152.
 */
package com.custom.httprequest.service;

import com.custom.httprequest.Cookie;
import com.custom.httprequest.Header;
import com.custom.httprequest.RequestContent;
import com.custom.httprequest.RequestService;
import com.custom.httprequest.ResponseContent;
import com.custom.httprequest.http.request.HttpRequestHeader;
import com.custom.httprequest.service.RequestREST;
import java.io.Serializable;

public abstract class HttpRequestService
extends HttpRequestHeader
implements RequestService,
Serializable {
    private static final long serialVersionUID = -5687887428405703283L;
    public static String ContentTypeForm = "application/x-www-form-urlencoded";
    public static String ContentTypeJson = "application/json";
    public static String ContentTypeMulti = "multipart/form-data";
    private Header PUBHEADER = null;
    private Cookie PUBCOOKIE = null;
    public ResponseContent response = null;
    public RequestContent request = null;

    public void initHeaders(Header header, Cookie cookie) throws Exception {
        this.mergeHeader(header);
        this.mergeCookie(cookie);
        this.PUBHEADER = header;
        this.PUBCOOKIE = cookie;
    }

    public void setRequestContent(RequestContent requestContent) {
        this.request = requestContent;
    }

    public RequestContent getRequestContent() {
        return this.request;
    }

    public ResponseContent getResponseContent() {
        return this.response;
    }

    public void setResponseContent(ResponseContent response) {
        this.response = response;
    }

    @Override
    public ResponseContent run() throws Exception {
        this.beforeRequest();
        this.afterBeforeRequest();
        this.send();
        this.afterSend();
        this.cookieSync();
        this.afterCookieSync();
        this.afterRequest();
        this.afterEnd();
        return this.getResponseContent();
    }

    private void cookieSync() {
        if (this.PUBCOOKIE != null) {
            this.PUBCOOKIE.merge(this.response.getCookie());
        }
    }

    private void send() throws Exception {
        ResponseContent rs = new RequestREST(this.getDomain(), this.getUri(), this.getMethod()).setHeader(this.getHeader()).setCookie(this.getCookie()).setContentRequest(this.request).send().getResponse();
        this.setResponseContent(rs);
    }

    public void afterBeforeRequest() {
    }

    public void afterSend() {
    }

    public void afterCookieSync() {
    }

    public void afterEnd() {
    }
}

