/*
 * Decompiled with CFR 0.152.
 */
package com.custom.common.json;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class JsonEntity {
    private JsonNode entity = null;

    public JsonEntity(String Json) {
        ObjectMapper mapper1 = new ObjectMapper();
        try {
            this.entity = mapper1.readTree(Json);
        }
        catch (Exception e3) {
            throw new RuntimeException("JsonEntity init failed ");
        }
    }

    public JsonEntity get(int index) {
        try {
            JsonNode a = this.entity.get(index);
            return new JsonEntity(a.toString());
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Json index [" + index + "] Not exist");
        }
    }

    public JsonEntity get(String name) {
        try {
            JsonNode a = this.entity.get(name);
            return new JsonEntity(a.toString());
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Json [" + name + "] Not exist");
        }
    }

    public boolean hasNode(String name) {
        return this.entity.get(name) != null;
    }

    public int size() {
        return this.entity.size();
    }

    public void show() {
        System.out.println(this.entity.toString());
    }

    public String toString() {
        String re = this.entity.toString();
        if (re.startsWith("\"") && re.endsWith("\"")) {
            re = re.substring(1, re.length() - 1);
        }
        return re;
    }

    public Integer toInteger() {
        String re = this.entity.toString();
        if (re.startsWith("\"") && re.endsWith("\"")) {
            re = re.substring(1, re.length() - 1);
        }
        return Integer.valueOf(re);
    }

    public Double toDouble() {
        String re = this.entity.toString();
        if (re.startsWith("\"") && re.endsWith("\"")) {
            re = re.substring(1, re.length() - 1);
        }
        return Double.valueOf(re);
    }

    public String URLEncoderString() {
        String re = null;
        try {
            re = URLEncoder.encode(this.entity.toString().replace("\"", ""), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return re;
    }

    public static String ConvertJson(Object a) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            json = mapper.writeValueAsString(a);
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return json;
    }

    public static <T> T JsonToBean(String jsonStr, Class<?> beanClass) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Object readValue = objectMapper.readValue(jsonStr, beanClass);
            return (T)readValue;
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Map<String, Object> JsonToMap(String jsonStr) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            HashMap a = new HashMap();
            Map map = (Map)mapper.readValue(jsonStr, a.getClass());
            return map;
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Map<String, String> JsonToMapSs(String jsonStr) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            HashMap a = new HashMap();
            Map map = (Map)mapper.readValue(jsonStr, a.getClass());
            return map;
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String MapToForm(Map<String, Object> maps) {
        String FormStr = "";
        for (String varKey : maps.keySet()) {
            String varValue = (String)maps.get(varKey);
            if (FormStr.length() > 0) {
                FormStr = FormStr + "&";
            }
            FormStr = FormStr + varKey + "=" + varValue;
        }
        return FormStr;
    }

    public static void main(String[] args) {
        String Json = "[{\"a\":\"1\"},{\"b\":\"2\"}]";
        JsonEntity t = new JsonEntity(Json);
        System.out.println(t.toString());
        System.out.println(t.get(3).get("b").toString());
    }
}

