/*
 * Decompiled with CFR 0.152.
 */
package com.custom.common.Encrypt;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class DESEncrypt {
    private static final String DES_ALGORITHM = "DES";

    public static String encryption(String plainData, String secretKey) throws Exception {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(DES_ALGORITHM);
            cipher.init(1, DESEncrypt.generateKey(secretKey));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            // empty catch block
        }
        try {
            byte[] buf = cipher.doFinal(plainData.getBytes());
            return Base64Utils.encode(buf);
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
            throw new Exception("IllegalBlockSizeException", e);
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
            throw new Exception("BadPaddingException", e);
        }
    }

    public static String decryption(String secretData, String secretKey) throws Exception {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(DES_ALGORITHM);
            cipher.init(2, DESEncrypt.generateKey(secretKey));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new Exception("NoSuchAlgorithmException", e);
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            throw new Exception("NoSuchPaddingException", e);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new Exception("InvalidKeyException", e);
        }
        try {
            byte[] buf = cipher.doFinal(Base64Utils.decode(secretData.toCharArray()));
            return new String(buf);
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
            throw new Exception("IllegalBlockSizeException", e);
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
            throw new Exception("BadPaddingException", e);
        }
    }

    private static SecretKey generateKey(String secretKey) throws NoSuchAlgorithmException {
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(secretKey.getBytes());
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(DES_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        kg.init(secureRandom);
        return kg.generateKey();
    }

    public static void main(String[] a) throws Exception {
        String input = "devel@g6n7FgVo";
        String key = "root";
        String result = DESEncrypt.encryption(input, key);
        System.out.println(result);
        System.out.println(DESEncrypt.decryption(result, key));
    }

    static class Base64Utils {
        private static char[] alphabet;
        private static byte[] codes;

        Base64Utils() {
        }

        public static String encode(byte[] data) {
            char[] out = new char[(data.length + 2) / 3 * 4];
            int i = 0;
            int index = 0;
            while (i < data.length) {
                boolean quad = false;
                boolean trip = false;
                int val = 0xFF & data[i];
                val <<= 8;
                if (i + 1 < data.length) {
                    val |= 0xFF & data[i + 1];
                    trip = true;
                }
                val <<= 8;
                if (i + 2 < data.length) {
                    val |= 0xFF & data[i + 2];
                    quad = true;
                }
                out[index + 3] = alphabet[quad ? val & 0x3F : 64];
                out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
                out[index + 1] = alphabet[(val >>= 6) & 0x3F];
                out[index + 0] = alphabet[(val >>= 6) & 0x3F];
                i += 3;
                index += 4;
            }
            return new String(out);
        }

        public static byte[] decode(char[] data) {
            int len = (data.length + 3) / 4 * 3;
            if (data.length > 0 && data[data.length - 1] == '=') {
                --len;
            }
            if (data.length > 1 && data[data.length - 2] == '=') {
                --len;
            }
            byte[] out = new byte[len];
            int shift = 0;
            int accum = 0;
            int index = 0;
            for (int ix = 0; ix < data.length; ++ix) {
                byte value = codes[data[ix] & 0xFF];
                if (value < 0) continue;
                accum <<= 6;
                accum |= value;
                if ((shift += 6) < 8) continue;
                out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
            }
            if (index != out.length) {
                throw new Error("miscalculated data length!");
            }
            return out;
        }

        static {
            int i;
            alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
            codes = new byte[256];
            for (i = 0; i < 256; ++i) {
                Base64Utils.codes[i] = -1;
            }
            for (i = 65; i <= 90; ++i) {
                Base64Utils.codes[i] = (byte)(i - 65);
            }
            for (i = 97; i <= 122; ++i) {
                Base64Utils.codes[i] = (byte)(26 + i - 97);
            }
            for (i = 48; i <= 57; ++i) {
                Base64Utils.codes[i] = (byte)(52 + i - 48);
            }
            Base64Utils.codes[43] = 62;
            Base64Utils.codes[47] = 63;
        }
    }
}

