/*
 * Decompiled with CFR 0.152.
 */
package com.custom.common.Encrypt.Base;

import com.custom.common.Encrypt.Base.Base64InputStream;
import com.custom.common.Encrypt.Base.Base64OutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class Base64 {
    private static byte[] base64DecodeChars = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    public static String encode(String str) throws RuntimeException {
        byte[] bytes = str.getBytes();
        byte[] encoded = Base64.encode(bytes);
        try {
            return new String(encoded, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ASCII is not supported!", e);
        }
    }

    public static String encode(String str, String charset) throws RuntimeException {
        byte[] bytes;
        try {
            bytes = str.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported charset: " + charset, e);
        }
        byte[] encoded = Base64.encode(bytes);
        try {
            return new String(encoded, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ASCII is not supported!", e);
        }
    }

    public static byte[] decode(String str) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        byte[] data = str.getBytes("US-ASCII");
        int len = data.length;
        int i = 0;
        while (i < len) {
            byte b4;
            byte b3;
            byte b2;
            byte b1;
            do {
                b1 = base64DecodeChars[data[i++]];
            } while (i < len && b1 == -1);
            if (b1 == -1) break;
            do {
                b2 = base64DecodeChars[data[i++]];
            } while (i < len && b2 == -1);
            if (b2 == -1) break;
            sb.append((char)(b1 << 2 | (b2 & 0x30) >>> 4));
            do {
                if ((b3 = data[i++]) == 61) {
                    return sb.toString().getBytes("iso8859-1");
                }
                b3 = base64DecodeChars[b3];
            } while (i < len && b3 == -1);
            if (b3 == -1) break;
            sb.append((char)((b2 & 0xF) << 4 | (b3 & 0x3C) >>> 2));
            do {
                if ((b4 = data[i++]) == 61) {
                    return sb.toString().getBytes("iso8859-1");
                }
                b4 = base64DecodeChars[b4];
            } while (i < len && b4 == -1);
            if (b4 == -1) break;
            sb.append((char)((b3 & 3) << 6 | b4));
        }
        return sb.toString().getBytes("iso8859-1");
    }

    public static String decode(String str, String charset) throws RuntimeException {
        byte[] bytes;
        try {
            bytes = str.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ASCII is not supported!", e);
        }
        byte[] decoded = Base64.decode(bytes);
        try {
            return new String(decoded, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported charset: " + charset, e);
        }
    }

    public static byte[] encode(byte[] bytes) throws RuntimeException {
        return Base64.encode(bytes, 0);
    }

    public static byte[] encode(byte[] bytes, int wrapAt) throws RuntimeException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Base64.encode(inputStream, outputStream, wrapAt);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected I/O error", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return outputStream.toByteArray();
    }

    public static byte[] decode(byte[] bytes) throws RuntimeException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Base64.decode(inputStream, outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected I/O error", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return outputStream.toByteArray();
    }

    public static void encode(InputStream inputStream, OutputStream outputStream) throws IOException {
        Base64.encode(inputStream, outputStream, 0);
    }

    public static void encode(InputStream inputStream, OutputStream outputStream, int wrapAt) throws IOException {
        Base64OutputStream aux = new Base64OutputStream(outputStream, wrapAt);
        Base64.copy(inputStream, aux);
        aux.commit();
    }

    public static void decode(InputStream inputStream, OutputStream outputStream) throws IOException {
        Base64.copy(new Base64InputStream(inputStream), outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encode(File source, File target, int wrapAt) throws IOException {
        FileInputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(source);
            outputStream = new FileOutputStream(target);
            Base64.encode(inputStream, outputStream, wrapAt);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encode(File source, File target) throws IOException {
        FileInputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(source);
            outputStream = new FileOutputStream(target);
            Base64.encode(inputStream, outputStream);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode(File source, File target) throws IOException {
        FileInputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(source);
            outputStream = new FileOutputStream(target);
            Base64.decode(inputStream, outputStream);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] b = new byte[1024];
        while ((len = inputStream.read(b)) != -1) {
            outputStream.write(b, 0, len);
        }
    }
}

