/*
 * Decompiled with CFR 0.152.
 */
package com.custom.common;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class DateUtil {
    public static final String DEF_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEF_TIME_FORMAT = "HH:mm:ss";
    public static final String DEF_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String MINUTE_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_yyyyMMddHHmmss = "yyyyMMddHHmmss";
    public static final String DEF_DATE_PATTERN = "\\d{4}\\-\\d{1,2}-\\d{1,2}";
    public static final String DEF_DATETIME_PATTERN = "\\d{4}\\-\\d{1,2}-\\d{1,2}\\p{javaWhitespace}\\d{1,2}:\\d{1,2}:\\d{1,2}";
    public static final String MINUTE_PATTERN = "\\d{4}\\-\\d{1,2}-\\d{1,2}\\p{javaWhitespace}\\d{1,2}:\\d{1,2}";

    private DateUtil() {
    }

    public static int compareDate(Date date1, Date date2) {
        long date2time;
        long date1time = DateUtil.getDate(DateUtil.formatDate(date1)).getTime();
        if (date1time > (date2time = DateUtil.getDate(DateUtil.formatDate(date2)).getTime())) {
            return 1;
        }
        if (date1time == date2time) {
            return 0;
        }
        return -1;
    }

    public static int compareDateTime(Date date1, Date date2) {
        long date2time;
        long date1time = DateUtil.getDateTime(DateUtil.formatDateTime(date1)).getTime();
        if (date1time > (date2time = DateUtil.getDateTime(DateUtil.formatDateTime(date2)).getTime())) {
            return 1;
        }
        if (date1time == date2time) {
            return 0;
        }
        return -1;
    }

    public static int compareTimestamp(Timestamp date1, Timestamp date2) {
        long date2time;
        if (date1 == null && date2 == null) {
            return 0;
        }
        if (date1 == null) {
            return -1;
        }
        if (date2 == null) {
            return 1;
        }
        long date1time = DateUtil.getDateTime(DateUtil.formatDateTime(date1)).getTime();
        if (date1time > (date2time = DateUtil.getDateTime(DateUtil.formatDateTime(date2)).getTime())) {
            return 1;
        }
        if (date1time == date2time) {
            return 0;
        }
        return -1;
    }

    public static Timestamp getSysTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Date getDate(String date) {
        if (!DateUtil.matchesPattern(date, DEF_DATE_PATTERN)) {
            return null;
        }
        return DateUtil.parseDate(date, DEF_DATE_FORMAT);
    }

    public static Timestamp getTimestamp(String date) {
        if (!DateUtil.matchesPattern(date, DEF_DATE_PATTERN)) {
            return null;
        }
        return new Timestamp(DateUtil.parseDate(date, DEF_DATE_FORMAT).getTime());
    }

    public static Date getDateTime(String datetime) {
        if (!DateUtil.matchesPattern(datetime, DEF_DATETIME_PATTERN)) {
            return null;
        }
        return DateUtil.parseDate(datetime, DEF_DATETIME_FORMAT);
    }

    public static Timestamp getDateTimeStamp(String datetime) {
        if (!DateUtil.matchesPattern(datetime, DEF_DATETIME_PATTERN)) {
            return null;
        }
        return new Timestamp(DateUtil.parseDate(datetime, DEF_DATETIME_FORMAT).getTime());
    }

    public static Date getDate(String date, String pattern) {
        return DateUtil.getDate(date, pattern, null);
    }

    public static Date getDate(String date, String pattern, Date defVal) {
        if (date == null || pattern == null) {
            return null;
        }
        if (date.endsWith("-00") || date.endsWith("-0")) {
            return null;
        }
        Date ret = DateUtil.parseDate(date, pattern);
        return ret == null ? defVal : ret;
    }

    private static Date parseDate(String date, String format) {
        Date d;
        try {
            d = new SimpleDateFormat(format).parse(date);
        }
        catch (ParseException e) {
            d = null;
        }
        return d;
    }

    public static boolean matchesPattern(String input, String pattern) {
        return input != null && input.matches(pattern);
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDateToString(date, DEF_DATE_FORMAT);
    }

    public static String dateAdd(Date d, int addDays) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(d);
        gc.add(5, addDays);
        gc.set(gc.get(1), gc.get(2), gc.get(5));
        return DateUtil.formatDateTime(gc.getTime());
    }

    public static String formatTime(Date date) {
        return DateUtil.formatDateToString(date, DEF_TIME_FORMAT);
    }

    public static String formatDateTime(Date date) {
        return DateUtil.formatDateToString(date, DEF_DATETIME_FORMAT);
    }

    public static String formateMinuteDate(Date date) {
        return DateUtil.formatDateToString(date, MINUTE_FORMAT);
    }

    private static String formatDateToString(Date date, String format) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static String formatDate(Date date, String format) {
        String ret;
        if (date == null || format == null) {
            return null;
        }
        try {
            ret = new SimpleDateFormat(format).format(date);
        }
        catch (RuntimeException e) {
            ret = null;
        }
        return ret;
    }

    public static Date getLastDayObjectInMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        if (d != null) {
            cal.setTime(d);
        }
        cal.add(2, 1);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static int getLastDayInMonth(Date d) {
        Date date = DateUtil.getLastDayObjectInMonth(d);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static Date getCurrentDate() {
        Date date = new Date(System.currentTimeMillis());
        return date;
    }

    public static String yyyyMMddHHmmss(Date date) {
        return DateUtil.formatDateToString(date, FORMAT_yyyyMMddHHmmss);
    }

    public static Timestamp getCurrentTime() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        return timestamp;
    }

    public static String dateToStr(Date source) {
        return DateUtil.dateToStr(source, DEF_DATETIME_FORMAT);
    }

    public static String dateToStr(Date source, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (source == null) {
            return "";
        }
        return sdf.format(source);
    }

    public static Calendar getCurrentCalendar() {
        Calendar calendar = Calendar.getInstance();
        return calendar;
    }

    public static Calendar getCurrentWeekBegin() {
        Calendar calendar = Calendar.getInstance();
        int dayOfWeek = calendar.get(7);
        int warpnum = 2 - dayOfWeek;
        if (dayOfWeek == 1) {
            warpnum = -6;
        }
        calendar.add(5, warpnum);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        calendar.set(year, month, day, 0, 0, 0);
        return calendar;
    }

    public static Calendar getNextWeekBegin() {
        Calendar calendar = DateUtil.getCurrentWeekBegin();
        calendar.add(5, 7);
        return calendar;
    }

    public static Calendar getPreWeekBegin() {
        Calendar calendar = DateUtil.getCurrentWeekBegin();
        calendar.add(5, -7);
        return calendar;
    }

    public static Calendar getCurrentMonthBegin() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.set(year, month, 1, 0, 0, 0);
        return calendar;
    }

    public static Calendar getNextMonthBegin() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.set(year, month + 1, 1, 0, 0, 0);
        return calendar;
    }

    public static Calendar getPreMonthBegin() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.set(year, month - 1, 1, 0, 0, 0);
        return calendar;
    }

    public static Calendar date2calendar(Date source) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(source);
        return calendar;
    }

    public static String formatFeedDate(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        Date today = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
        String timestampStr = formatter.format(timestamp);
        String todayStr = formatter.format(today);
        if (todayStr.substring(0, 11).equals(timestampStr.substring(0, 11))) {
            return "\u4eca\u5929" + timestampStr.substring(11, timestampStr.length());
        }
        return timestampStr;
    }

    public static void main(String[] args) {
        try {
            DateUtil.getCurrentWeekBegin();
            DateUtil.getNextWeekBegin();
            DateUtil.getCurrentMonthBegin();
            DateUtil.getNextMonthBegin();
            System.out.println(DateUtil.formatDate(DateUtil.getCurrentDate(), "HHmmss1992MMddyyHH"));
            System.out.println(DateUtil.formatDate(DateUtil.getCurrentDate(), "dd"));
            System.out.println(DateUtil.matchesPattern("2012-05-03 03:84:55", DEF_DATETIME_PATTERN));
            System.out.println(DateUtil.getDateTime(DateUtil.formatDateTime(DateUtil.getCurrentTime())).getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String transferSec2Hms(int second) {
        int hour = second / 3600;
        int minute = second % 3600 / 60;
        int sec = second % 3600 % 60;
        StringBuffer buf = new StringBuffer();
        buf.append(hour).append("\u5c0f\u65f6").append(minute).append("\u5206").append(sec).append("\u79d2");
        return buf.toString();
    }

    public static long getDateDiffNum(Date date1, Date date2) {
        long diff = date1.getTime() - date2.getTime();
        long days = diff / 86400000L;
        return days;
    }
}

