/*
 * Decompiled with CFR 0.152.
 */
package com.custom.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class JsonConverter {
    public static <T> T json2Bean(String json, Class<?> Class2) {
        return (T)JSON.parseObject((String)json, Class2);
    }

    public static Map<String, Object> json2Map(String json) {
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    public static Map<String, String> json2MapString(String json) {
        return (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
    }

    public static String o2json(Object o) {
        return JSON.toJSONString((Object)o);
    }

    public static String toForm(String json) {
        Map<String, Object> m = JsonConverter.json2Map(json);
        return JsonConverter.toForm(m);
    }

    public static String toForm(Map<String, Object> maps) {
        String FormStr = "";
        for (String varKey : maps.keySet()) {
            String varValue = (String)maps.get(varKey);
            if (FormStr.length() > 0) {
                FormStr = FormStr + "&";
            }
            FormStr = FormStr + varKey + "=" + varValue;
        }
        return FormStr;
    }

    public static String xml2json(File file) {
        String str = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            ByteBuffer bb = ByteBuffer.allocate(new Long(file.length()).intValue());
            fc.read(bb);
            bb.flip();
            str = new String(bb.array(), "UTF8");
            fc.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public static String xml2Json(String xmlStr) {
        try {
            Document doc = DocumentHelper.parseText((String)xmlStr);
            JSONObject json = new JSONObject();
            JsonConverter.dom4j2Json(doc.getRootElement(), json);
            return json.toJSONString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void dom4j2Json(Element element, JSONObject json) {
        for (Object o : element.attributes()) {
            Attribute attr = (Attribute)o;
            if (JsonConverter.isEmpty(attr.getValue())) continue;
            json.put("@" + attr.getName(), (Object)attr.getValue());
        }
        List chdEl = element.elements();
        if (chdEl.isEmpty() && !JsonConverter.isEmpty(element.getText())) {
            json.put(element.getName(), (Object)element.getText());
        }
        for (Element e : chdEl) {
            if (!e.elements().isEmpty()) {
                JSONObject chdjson = new JSONObject();
                JsonConverter.dom4j2Json(e, chdjson);
                Object o = json.get((Object)e.getName());
                if (o != null) {
                    JSONArray jsona = null;
                    if (o instanceof JSONObject) {
                        JSONObject jsono = (JSONObject)o;
                        json.remove((Object)e.getName());
                        jsona = new JSONArray();
                        jsona.add((Object)jsono);
                        jsona.add((Object)chdjson);
                    }
                    if (o instanceof JSONArray) {
                        jsona = (JSONArray)o;
                        jsona.add((Object)chdjson);
                    }
                    json.put(e.getName(), (Object)jsona);
                    continue;
                }
                if (chdjson.isEmpty()) continue;
                json.put(e.getName(), (Object)chdjson);
                continue;
            }
            System.out.println(e.getName());
            for (Object o : element.attributes()) {
                Attribute attr = (Attribute)o;
                if (JsonConverter.isEmpty(attr.getValue())) continue;
                json.put("@" + attr.getName(), (Object)attr.getValue());
            }
            if (e.getText().isEmpty()) continue;
            Object o = json.get((Object)e.getName());
            if (o != null) {
                JSONArray jsona = null;
                if (o instanceof JSONArray) {
                    jsona = (JSONArray)o;
                    jsona.add((Object)e.getText());
                } else {
                    json.remove((Object)e.getName());
                    jsona = new JSONArray();
                    jsona.add(o);
                    jsona.add((Object)e.getText());
                }
                json.put(e.getName(), (Object)jsona);
                continue;
            }
            json.put(e.getName(), (Object)e.getText());
        }
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty() || "null".equals(str);
    }

    public static String json2XML(String json, Object key) {
        Map<String, Object> m = JsonConverter.json2Map(json);
        return JsonConverter.map2XML(m, key);
    }

    public static String map2XML(Map _obj, Object key) {
        StringBuffer xml = new StringBuffer(1024);
        xml.append("<").append(key).append(">\n");
        System.out.println(JsonConverter.o2json(_obj));
        xml.append(JsonConverter.map2XML(_obj));
        xml.append("</").append(key).append(">");
        return xml.toString();
    }

    private static String map2XML(Map _obj) {
        StringBuffer sb = new StringBuffer();
        if (_obj != null) {
            _obj.forEach((key, value) -> {
                if (value instanceof Map) {
                    sb.append(JsonConverter.toXMLMap((Map)value, key));
                } else if (value instanceof Collection) {
                    sb.append(JsonConverter.toXMLCollection((Collection)value, key));
                } else {
                    sb.append(JsonConverter.toXMLOtherObject(value == null ? "null" : value, key));
                }
            });
        }
        return sb.toString();
    }

    private static String toXMLCollection(Collection _list, Object key) {
        StringBuffer sb = new StringBuffer();
        if (_list != null) {
            for (Object o : _list) {
                if (o instanceof Map) {
                    sb.append("<").append(key).append(">").append("\n");
                    sb.append(JsonConverter.map2XML((Map)o));
                    sb.append("</").append(key).append(">").append("\n");
                    continue;
                }
                sb.append(JsonConverter.toXMLOtherObject(o == null ? "null" : o, key));
            }
        }
        return sb.toString();
    }

    private static String toXMLMap(Map _map, Object node) {
        StringBuffer sb = new StringBuffer();
        if (_map != null) {
            sb.append("<").append(node).append(">").append("\n");
            sb.append(JsonConverter.map2XML(_map));
            sb.append("</").append(node).append(">").append("\n");
        }
        return sb.toString();
    }

    private static String toXMLOtherObject(Object _obj, Object key) {
        StringBuffer sb = new StringBuffer();
        if (_obj != null) {
            sb.append("<").append(key).append(">");
            sb.append(_obj.toString());
            sb.append("</").append(key).append(">").append("\n");
        }
        return sb.toString();
    }
}

