/*
 * Decompiled with CFR 0.152.
 */
package com.custom.httprequest.util;

import com.custom.httprequest.ResponseContent;
import com.custom.httprequest.connector.HttpRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpResponseUtil {
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String CHAR_SPACE = " ";
    public static final String CHAR_COOKIES_SPLIT = ";";
    public static final String CHAR_COOKIES_KVSPLIT = "=";

    public static void parseResponse(ResponseContent response, HttpRequest request) {
        Map<String, List<String>> h = request.headers();
        Set<Map.Entry<String, List<String>>> set = h.entrySet();
        for (Map.Entry<String, List<String>> entry : set) {
            List<String> values = entry.getValue();
            if (entry.getKey() == null) {
                String[] v = values.get(0).split(CHAR_SPACE);
                response.setVersion(v[0]);
                response.setStatus(Integer.valueOf(v[1]));
                for (int inx = 2; inx < v.length; ++inx) {
                    if (inx > 2) {
                        response.setReason(response.getReason() + CHAR_SPACE);
                    }
                    response.setReason(response.getReason() + v[inx]);
                }
                continue;
            }
            if (SET_COOKIE.equals(entry.getKey())) {
                String[] setcookie;
                for (String sc : setcookie = values.get(0).split(CHAR_COOKIES_SPLIT)) {
                    String[] k = sc.split(CHAR_COOKIES_KVSPLIT, 2);
                    String[] sk = Arrays.copyOf(k, 2);
                    if (null == sk[1]) continue;
                    response.putCookie(sk[0], sk[1]);
                }
                continue;
            }
            response.putHeader(entry.getKey(), values.get(0));
        }
        response.setByteBody(request.bodyBytes());
    }
}

