/*
 * Decompiled with CFR 0.152.
 */
package com.custom.httprequest.http.request.content.item;

import com.custom.httprequest.FileType;
import java.io.File;
import java.io.Serializable;

public class HttpFileEntity
implements Serializable {
    private static final long serialVersionUID = 5053612344656980218L;
    private String path = "";
    private String name = "";
    private String type = "";

    public HttpFileEntity(String filePath) throws Exception {
        File f = new File(filePath);
        if (!f.exists()) {
            throw new Exception("file [ " + filePath + " ] not exist !!!");
        }
        this.name = f.getName();
        this.path = f.getParent();
        int posSuffix = this.name.lastIndexOf(46);
        this.type = FileType.getType(this.name.substring(posSuffix + 1));
    }

    public HttpFileEntity(String path, String name, String type) throws Exception {
        String filePath = path + "\\" + name;
        File f = new File(filePath);
        if (!f.exists()) {
            throw new Exception("file [ " + filePath + " ] not exist !!!");
        }
        this.path = path;
        this.name = name;
        this.type = type;
    }

    public String getPath() {
        return this.path;
    }

    public String getFilePath() {
        return this.path + "\\" + this.name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

