var log, className = "dark", startTime = 0, endTime = 0, perCount = 100, perTime = 100;
//ztree 配置
var setting = {
	async : {
		enable : true,
		type : "get",
		url : getUrl  //点击 + 后号执行的操作 function
	},
	check : {
		enable : false  //是否启用 check 标签
	},
	data : {
		simpleData : {
			enable : true
		}
	},
	view : {
		expandSpeed : ""
	},
	callback : {
		beforeExpand : beforeExpand,  //展开前的function 操作
		onAsyncSuccess : onAsyncSuccess,  //数据同步成功后的 function 操作
		onAsyncError : onAsyncError //数据同步失后的 function 操作
	}
};

//默认的树根节点
var RootNodes = [ {
	name : "MockServer",
	id : "ROOT",
	nodeType : "ROOT",
	click : "RootDetail()",
	isParent : true
} ];

$(document).ready(load);

function load() {
	$.fn.zTree.init($("#MockProjectTree"), setting, RootNodes);

}


function Error() {
	alert("系统异常");
}


function getUrl(treeId, treeNode) {
	//节点是 ROOT 节点返回 操作URI
	if (treeNode.nodeType == "ROOT") {
		return "/mock/project";
	}
	
	//节点是 project 节点返回 操作URI
	if (treeNode.nodeType == "project") {
		return "/mock/uri/project/"+treeNode.id;
	}
	
	//节点是 uri 节点返回 操作URI
	if (treeNode.nodeType == "uri") {
		return "/mock/request/uri/"+treeNode.id;
	}
	
	//节点是 uri 节点返回 操作URI
	if (treeNode.nodeType == "request") {
		return "/mock/callback/request/"+treeNode.id;
	}
	

}


function beforeExpand(treeId, treeNode) {
	if (!treeNode.isAjaxing) {
		startTime = new Date();
		treeNode.times = 1;
		ajaxGetNodes(treeNode, "refresh");
		return true;
	} else {
		alert("正在下载数据中，请稍后展开节点。。。");
		return false;
	}
}
function onAsyncSuccess(event, treeId, treeNode, msg) {

	if (!msg || msg.length == 0) {
		return;
	}

	var chirldrens =chirldrens=getZTreeJson(msg,treeNode.nodeType);
	
	
	
	var zTree = $.fn.zTree.getZTreeObj("MockProjectTree"), totalCount = treeNode.count;
	if (treeNode.children.length < totalCount) {
		setTimeout(function() {
			ajaxGetNodes(treeNode);
		}, perTime);
	} else {
		treeNode.icon = "";
		zTree.updateNode(treeNode);
		zTree.removeChildNodes(treeNode);
		zTree.addNodes(treeNode, chirldrens);
		endTime = new Date();
		var usedTime = (endTime.getTime() - startTime.getTime()) / 1000;
		className = (className === "dark" ? "" : "dark");

	}
}
function onAsyncError(event, treeId, treeNode, XMLHttpRequest, textStatus,
		errorThrown) {
	var zTree = $.fn.zTree.getZTreeObj("MockProjectTree");
	alert("异步获取数据出现异常。");
	treeNode.icon = "";
	zTree.updateNode(treeNode);
}

function ajaxGetNodes(treeNode, reloadType) {
	var zTree = $.fn.zTree.getZTreeObj("MockProjectTree");
	if (reloadType == "refresh") {
		treeNode.icon = "/css/zTreeStyle/img/loading.gif";
		zTree.updateNode(treeNode);
	}
	zTree.reAsyncChildNodes(treeNode, reloadType, true);
}

function getTime() {
	var now = new Date(), h = now.getHours(), m = now.getMinutes(), s = now
			.getSeconds(), ms = now.getMilliseconds();
	return (h + ":" + m + ":" + s + " " + ms);
}

function getZTreeJson(data,parentType) {
	var type ;
	if (parentType =="ROOT"){
		type="project"
	} else if (parentType =="project"){
		type="uri"
	} else if (parentType =="uri"){
		type="request"
	}	else if (parentType =="request"){
		type="callback"
	}
	var projects = new Array();
	var entity = eval("(" + data + ")").entity;
	if (entity.status == 200) {
		for (var i = 0; i < entity.data.length; i++) {
			var proJson;
			if (type =="project"){
				proJson = {
						name : "[服务项目]"+entity.data[i].mockProjectName,
						id : entity.data[i].id,
						nodeType : type,
						isParent : true,
						click : "ProjectDetail('"+entity.data[i].id+"')"
					};
			} else if(type =="uri"){
				proJson = {
						name : "[接口]"+entity.data[i].mockUriName,
						id : entity.data[i].id,
						nodeType : type,
						isParent : true,
						click : "UriDetail('"+entity.data[i].id+"')"
					};
			}else if(type =="request"){
				proJson = {
						name : "[策略]"+entity.data[i].mockRequestName,
						id : entity.data[i].id,
						nodeType : type,
						isParent : true,
						click :"RequestDetail('"+entity.data[i].id+"')"
					};
			}else if(type =="callback"){
				proJson = {
						name : "[回调]"+entity.data[i].callbackName,
						id : entity.data[i].id,
						nodeType : type,
						isParent : false,
						click :""
					};
			}
			
			
			
			
			
			projects.push(proJson);

		}

	}
	return projects;
}

//<li id="title" class="title">title</li>
//<li id="search" class="title">search</li>
//<li id="body" class="title">body</li>
function RootDetail(){
	showRootPage();
}




function ProjectDetail(projectId){
	showProjectPage(projectId);
}

function UriDetail(uriId){
	showUriPage(uriId);
}

function RequestDetail(requestId){
	
	showRequestPage(requestId);
	
}