require.config({
	paths:{
		'jquery'				:'/js/static/jquery',
		'require'				:'/js/static/require',
		'common-util'			:'/js/common/common-util',
		'httprequest'			:'/js/common/httprequest',
		'bootstrap' 			:'/bootstrap/js/bootstrap',
		'bootstrap-dialog' 		:'/bootstrap-dialog/bootstrap-dialog',
		'bootstrap-treeview' 	:'/bootstrap-treeview/bootstrap-treeview',
		'mock-project' 			:'/js/common/mock-project',
		'mock-uri' 				:'/js/common/mock-uri',
		'mock-request' 			:'/js/common/mock-request',
		'mock-callback' 		:'/js/common/mock-callback',
		
		},		
		
	shim: {
	        'jquery': {
	            exports: 'jquery'
	        },
	        
	        'bootstrap': {
	            deps: ['jquery']
	        },
	        
	        'bootstrap-dialog': {
	        	deps: ['jquery','bootstrap']
	        },
	        
	        'bootstrap-treeview': {
	        	deps: ['jquery','bootstrap']
	        },
	        
	        'httprequest': {
	        	deps: ['jquery','common-util']
	        },
	        
	        'mock-request': {
	        	deps: ['jquery','bootstrap-dialog','httprequest','mock-callback']
	        },
	        
	        'mock-uri': {
	        	deps: ['jquery','bootstrap-dialog','httprequest','mock-request']
	        },
	        
	        'mock-project': {
	        	deps: ['jquery','bootstrap-dialog','httprequest','mock-uri']
	        },
	        
	        
	        
	      }
	});


require(['jquery','httprequest','bootstrap-dialog','mock-project','bootstrap-treeview'],
function($,httprequest,BootstrapDialog,mockproject){
	mockproject.init();
});