function showProjectPage(projectId) {
	showProjectTitle(projectId);
	showProjectSearch();
	showProjectBody(projectId);
	newUri.mockProjectId = projectId;
}

function showProjectTitle(projectId) {
	$("#title")
			.html(
					"<h2>接口URI 管理</h2> <a onclick=\"UriPop(newUri,'新增Uri','insert')\" href='#'>新增</> ");
}

function showProjectSearch() {
	$("#search").html("<hr>");
}

function showProjectBody(projectId) {
	var bodyTalbe = "<table width='100%' border=1 class='Datatable'>" //
			+ "<thead>" //
			+ "<tr>"//
			+ "<th>序号</th>" //
			+ "<th>接口名称</th>" //
			+ "<th>接口URI</th>" //
			+ "<th>Method</th>"//		
			+ "<th>状态</th>"//
			+ "<th>操作</th>"//
			+ "</tr>"//
			+ "</thead>" //
			+ "<tbody id='queryDataTable'>" //
			+ "</tbody>"//
			+ "<table>";
	$("#body").html(bodyTalbe);

	$.ajax({
				type : "get",
				url : "/mock/uri/project/" + projectId,
				error : function() {
					alert("Error")
				},
				success : function(data) {
					var entity = eval(data).entity;
					if (entity.status == 200) {
						$("#queryDataTable").html("");

						var tr = "<tr>";

						for (var i = 0; i < entity.data.length; i++) {
							uris[i] = entity.data[i];

							tr += "<td><p>" + (i + 1) + "</p></td>";
							tr += "<td><p>" + entity.data[i].mockUriName
									+ "</p></td>";
							tr += "<td><p>" + entity.data[i].mockUri
									+ "</p></td>";
						
							tr += "<td><p>" + entity.data[i].mockMethod
									+ "</p></td>";
						
							tr += "<td><p>" + entity.data[i].isRun
									+ "</p></td>";
							tr += "<td >";	
							tr += "<a onclick=\"UriPop(uris["
									+ i
									+ "],'编辑Uri','update')\" href=\"#\">编辑</a> &nbsp;&nbsp;&nbsp;&nbsp;";
							tr += "<a onclick=\"deleteUri('"+entity.data[i].id+"')\" href=\"#\">删除</a>";
							tr += "</td>";
							tr += "</tr>";
						}
						$("#queryDataTable").append(tr);
					}
				}
			});
}

function UriPop(uri, title, saveOrUpdate) {

	var proTable = ""
	proTable += "<table class='tableInput'>";
	proTable += "<tr>";
	proTable += "<td > 接口名：</td>";
	proTable += "<td colspan='3'> ";
	proTable += "<input type='hidden' id='UriId' value=''  >";
	proTable += "<input type='hidden' id='UriProjectId' value=''  >";
	proTable += "<input type='text' id='UriName' class='wt300' value=''  >";
	proTable += "</td>";
	proTable += "</tr>";

	proTable += "<tr>";
	proTable += "<td > Method： </td >";
	proTable += "<td >";
	proTable += "<input type='text' id='UriMethod' class='wt100' value='' >";
	proTable += "</td>";

	proTable += "<td > 状态： </td >";
	proTable += "<td>";
	proTable += "<select id='IsRun' class='wt100'>";	
	proTable += "<option id='IsRunRUN' value='RUN'>启用</option>";
	proTable += "<option id='IsRunSTOP' value='STOP'>停用</option>";
	proTable += "</select>";
	proTable += "</td></tr>";
	
	proTable += "<tr>";
	proTable += "<td > URI：</td>";
	proTable += "<td colspan='3'>";
	proTable += "<input type='text' id='UriPath' class='wt300' value='' ></td>";
	proTable += "</tr>";
	proTable += "</table>";
	new pop.ui.alert({
		title : title,
		content : proTable,
		width : 500,
		beforeCallback : function() {
		$('#UriId').val( uri.id  );
		$('#UriProjectId').val( uri.mockProjectId );			
		$('#UriName').val( uri.mockUriName );				
		$('#UriMethod').val( uri.mockMethod);				
		$('#IsRun' + uri.isRun).attr('selected', 'selected');
		$('#UriPath').val( uri.mockUri );
		

		},
		callback : function() {
			saveOrUpdateUri(saveOrUpdate);
		}
	}).init();
}

function saveOrUpdateUri(SaveOrUpdate) {
	reqType = SaveOrUpdate == "insert" ? "POST" : "PUT";
	var URL = "/mock/uri";
	var uriSU = {};
	if (reqType == "PUT") {
		uriSU.id = $('#UriId').val();
	}
	uriSU.mockProjectId = $('#UriProjectId').val();
	uriSU.mockUriName = $('#UriName').val();
	uriSU.mockUri = $('#UriPath').val();
	uriSU.mockMethod = $('#UriMethod').val();
	uriSU.isRun = $('#IsRun').val();
	
	// versionO.detail = $('#VersionDetail').htmlarea('html');	
	
	data = JSON.stringify(uriSU);
	
	$.ajax({
		type : reqType,
		url : URL,
		contentType:'application/json; charset=UTF-8',
		data : data,		
		error : Error,
		success : function(data) {
			var obj = eval(data).entity;
			var status = obj.status;
			if (status == "201" || status == "200") {
				showProjectBody(uriSU.mockProjectId)
				alert("操作成功！");

			} else {
				alert("操作失败");
			}
		}
	});
}

function deleteUri(id){
	var a=confirm("确认删除？");
	 if(a==false){
		 return;
	 }
	var URL = "/mock/uri";
	var uriSU = {id:id};
	data = JSON.stringify(uriSU);
	$.ajax({
		type : "DELETE",
		url : URL,	
		contentType:'application/json; charset=UTF-8',
		data : data,
		error : Error,
		success : function(data) {
			var obj = eval(data).entity;
			var status = obj.status;
			if (status == "201" || status == "200") {
				showProjectBody(newUri.mockProjectId)
				alert("删除成功！");

			} else {
				alert(obj.message)
			}
		}
	});	
	
}

var uris = new Array()

var newUri = {
	id : "",
	mockProjectId : "",
	mockUriName : "",
	mockUri : "",
	mockMethod : "GET",
	isRun : "RUN",
}
