/*
 * Decompiled with CFR 0.152.
 */
package com.custom.httprequest.http.response;

import com.custom.httprequest.Cookie;
import com.custom.httprequest.Header;
import com.custom.httprequest.Parametric;
import com.custom.httprequest.ResponseContent;
import com.custom.httprequest.ResponseLine;
import com.custom.httprequest.connector.Base64;
import com.custom.httprequest.http.response.HttpResponseHeaders;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class HttpResponseEntity
implements ResponseLine,
ResponseContent,
Serializable {
    private static final long serialVersionUID = 2555502904239591634L;
    public static String defaultCharset = "UTF-8";
    private String charset = null;
    private byte[] byteBody = null;
    private HttpResponseHeaders headers = new HttpResponseHeaders();

    @Override
    public void setByteBody(byte[] byteBody) {
        this.byteBody = byteBody;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public String getCharset() {
        if (this.charset == null) {
            return defaultCharset;
        }
        return this.charset;
    }

    @Override
    public byte[] getByteBody() {
        return this.byteBody;
    }

    @Override
    public String getContentType() {
        return this.headers.getHeader("Content-Type");
    }

    @Override
    public String getContent() {
        return this.getContent(this.getCharset());
    }

    @Override
    public String getContent(String charset) {
        if (this.byteBody == null) {
            return null;
        }
        try {
            return new String(this.byteBody, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public int getStatus() {
        return this.headers.getStatus();
    }

    @Override
    public void setStatus(int status) {
        this.headers.setStatus(status);
    }

    @Override
    public String getVersion() {
        return this.headers.getVersion();
    }

    @Override
    public void setVersion(String version) {
        this.headers.setVersion(version);
    }

    @Override
    public String getReason() {
        return this.headers.getReason();
    }

    @Override
    public void setReason(String reason) {
        this.headers.setReason(reason);
    }

    @Override
    public void setCookie(Cookie cookie) {
        this.headers.setCookie(cookie);
    }

    @Override
    public void setCookie(Map<String, String> CookieMap) {
        this.headers.setCookie(CookieMap);
    }

    @Override
    public Cookie getCookie() {
        return this.headers.getCookie();
    }

    @Override
    public void mergeCookie(Cookie cookie) {
        this.headers.mergeCookie(cookie);
    }

    @Override
    public void mergeCookie(Map<String, String> CookieMap) {
        this.headers.mergeCookie(CookieMap);
    }

    @Override
    public void mergeCookie(Parametric<String> pm) {
        this.headers.mergeCookie(pm);
    }

    @Override
    public void putCookie(String key, String value) {
        this.headers.putCookie(key, value);
    }

    @Override
    public boolean containsCookie(String key) {
        return this.headers.containsCookie(key);
    }

    @Override
    public String getCookie(String key) {
        return this.headers.getCookie(key);
    }

    @Override
    public void removeCookie(String key) {
        this.headers.removeHeader(key);
    }

    @Override
    public void clearCookie() {
        this.headers.clearCookie();
    }

    @Override
    public Map<String, String> getMapCookie() {
        return this.headers.getMapCookie();
    }

    @Override
    public Cookie cloneCookie() {
        return this.headers.cloneCookie();
    }

    @Override
    public void setHeader(Header header) {
        this.headers.setHeader(header);
    }

    @Override
    public void setHeader(Map<String, String> HeaderMap) {
        this.headers.setHeader(HeaderMap);
    }

    @Override
    public void mergeHeader(Header header) {
        this.headers.mergeHeader(header);
    }

    @Override
    public void mergeHeader(Map<String, String> HeaderMap) {
        this.headers.mergeHeader(HeaderMap);
    }

    @Override
    public void mergeHeader(Parametric<String> pm) {
        this.headers.mergeHeader(pm);
    }

    @Override
    public void putHeader(String key, String value) {
        this.headers.putHeader(key, value);
    }

    @Override
    public boolean containsHeader(String key) {
        return this.headers.containsHeader(key);
    }

    @Override
    public Header getHeader() {
        return this.headers.getHeader();
    }

    @Override
    public String getHeader(String key) {
        return this.headers.getHeader(key);
    }

    @Override
    public void removeHeader(String key) {
        this.headers.removeHeader(key);
    }

    @Override
    public void clearHeader() {
        this.headers.clearHeader();
    }

    @Override
    public Map<String, String> getMapHeader() {
        return this.headers.getMapHeader();
    }

    @Override
    public Header cloneHeader() {
        return this.headers.cloneHeader();
    }

    @Override
    public String getBase64Content() {
        return Base64.encodeBytes(this.getByteBody(), "UTF-8");
    }

    @Override
    public String getBase64Content(String charset) {
        return Base64.encodeBytes(this.getByteBody(), charset);
    }
}

