define(['jquery','httprequest','bootstrap-dialog','mock-uri'],
function($,httprequest,BootstrapDialog,mockUri){
	MockProject ={}
	
	MockProject.init = function(){ 
		$("#d-project").html("<ul id='projectUl' class='nav nav-tabs' role='tablist'></ul>");
		
		var editLi ="<li role=\"presentation\"><a title='编辑当前选中MOCK系统信息' id=\"editCurrentProject\", class=\"glyphicon glyphicon-cog\"></a></li>";
		var addLi ="<li role=\"presentation\"><a title='新增MOCK系统' id=\"CreateProject\" class=\"glyphicon glyphicon-plus\"></a></li>";
		var delLi ="<li role=\"presentation\"><a title='删除当前选中MOCK系统信息'id=\"delCurrentProject\"  class=\"glyphicon glyphicon-minus\"></a></li>";
		
		$("#projectUl").append(editLi);
		$("#projectUl").append(addLi);
		$("#projectUl").append(delLi);
		
		$("#editCurrentProject").on("click",function(){
			var proId=$(this).attr('currentProId');
			var proName=$(this).attr('currentProName');
			if(proId != undefined){
				MockProject.editProejctDialog(proId,proName);
			} else {
				BootstrapDialog.alert("请先选择对应的系统标签,再进行修改！！！！")
			}
		});
		
		$("#CreateProject").on("click",function(){
			MockProject.createProejctDialog();
		});
		
		$("#delCurrentProject").on("click",function(){
			var proId=$(this).attr('currentProId');
			if(proId != undefined){
				MockProject.deleteProejct(proId)
			} else {
				BootstrapDialog.alert("请先选择对应的系统标签,再进行修改！！！！")
			}
		});
		
		httprequest.send({
			type : "GET",
			url : "/mock/project",
			dataType:"json",
			success : function(obj,status) {
				var entity = obj.entity;
				if (entity.status == 200) {
					for (var i = 0; i < entity.data.length; i++) {
						var li = "<li role='presentation' id='lipro"+entity.data[i].id+"'>";
						li += "<a id='pro"+entity.data[i].id+"'  proId ='"+entity.data[i].id+"' proName ='"+entity.data[i].mockProjectName+"' href='javascript:void(0)' >"+entity.data[i].mockProjectName+"</a>";
						li += "</li>";
						$("#projectUl").append(li);
						
						
						$("#pro"+entity.data[i].id).on("click",function(){
							
							var proId=$(this).attr('proId');

							$("[role='presentation'][class='active']").attr("class","");
							$("#lipro"+proId).attr("class","active");
							
							var mockProjectName=$(this).attr('proName');
							$("#editCurrentProject").attr("currentProId",proId);
							$("#editCurrentProject").attr("currentProName",mockProjectName);
							$("#delCurrentProject").attr("currentProId",proId);
							mockUri.showUrlByProjectId(proId);
						});
					}
					
				}else {
					alert(obj.message)
				}
			}
		});
	}
	
	
	MockProject.createProejctDialog = function(){
				
		 BootstrapDialog.show({
//	            size: BootstrapDialog.SIZE_WIDE,
	            title:"新增系统",
	            message: tableDemo("",""),
	            closable: true,
	            closeByBackdrop: false,
	            closeByKeyboard: false,
	            buttons: [{
	                label: '确定',
	                cssClass: 'btn-primary',
	                action: function(dialog){
	            		saveProject("insert",dialog)
	                }
	            }, {
	                label: '取消',
	                action: function(dialog){
	            	dialog.close();
	                }
	            }],
	            onshown : function(){}
	        });
	}
	
	MockProject.editProejctDialog = function(proId,proName){
		
		 BootstrapDialog.show({
//	            size: BootstrapDialog.SIZE_WIDE,
	            title:"修改系统信息",
	            message: tableDemo(proId,proName),
	            closable: true,
	            closeByBackdrop: false,
	            closeByKeyboard: false,
	            buttons: [{
	                label: '确定',
	                cssClass: 'btn-primary',
	                action: function(dialog){
	            		saveProject("update",dialog)
	                }
	            }, {
	                label: '取消',
	                action: function(dialog){
	            	dialog.close();
	                }
	            }]
	        });
	}	
	
	
	MockProject.deleteProejct = function(proId){
		var a=confirm("确认删除？");
		 if(a==false){
			 return;
		 }
		httprequest.send({
			type : "DELETE",
			url : "/mock/project",		
			contentType:'json',
			dataType:'json',
			data : {id:proId},
			success : function(obj,status) {
				var entity = obj.entity;
				var status = entity.status;
				if (status == "201" || status == "200") {
					MockProject.init();
					BootstrapDialog.alert("删除成功！");

				} else {
					BootstrapDialog.alert(entity.message);
				}
			}
		});	
	}
	
	function saveProject(SaveOrUpdate,dialog) {
		var type = SaveOrUpdate == "insert" ? "POST" : "PUT";
		var project = {};
		
		if (type == "PUT") {
			project.id = $('#pro_id').val();
		}

		project.mockProjectName = $('#pro_Name').val();
		httprequest.send({
			type : type,
			url : "/mock/project",
			contentType:'json',
			dataType:'json',
			data : project,
			success : function(obj,statud) {
				dialog.close(); 
				var entity = obj.entity;
				var status = entity.status;
				if (status == "201" || status == "200") {
					MockProject.init();
					BootstrapDialog.alert("操作成功！");

				}else {
					BootstrapDialog.alert(entity.message)
				}
			}
		});
	}
	
	
	function tableDemo(proId,proName){
		var proTable = "";
		proTable += "<table class='table'>";
		proTable += "<tr>";
		proTable += "<td>名称：</td >";
		proTable += "<td >";
		proTable += "<input type='hidden' id='pro_id' value='" + proId
				+ "'  >"
		proTable += "<input type='text' id='pro_Name' value='"
				+ proName + "'  >";
		proTable += "</td>";
		proTable += "</tr>";
		proTable += "</table>";
		return proTable
	}
	
	
	return MockProject
	
	
});