var express = require('express');
var app = express();
var fortune = require('./lib/fortune.js');
var about = require('./lib/about.js');
var bodyParser = require('body-parser'); 
var ding = require('./lib/dingding.js');
var time = require('silly-datetime')
// var db = require('./routes/db.js');
/* 导入mysql模块 */
var mysql = require('mysql');
var dbconfig = require('./db/DBConfig');
var userSQL = require('./db/Usersql');
var pool = mysql.createPool(dbconfig.mysql);  // 使用DBConfig.js的配置信息创建一个MySQL连接池
// 设置 handlebars 视图引擎
// var handlebars = require('express3-handlebars')
//             .create({ defaultLayout:'main',
//             helpers: {
// 				section: function(name, options){ 
// 					if(!this._sections) this._sections = {}; 
// 					this._sections[name] = options.fn(this); 
// 					return null;
// 				} 
// 			} 
// });
// app.engine('handlebars', handlebars.engine);
// 设置模板类型
app.set('views', './views');

// 设置端口号
app.set('port', process.env.PORT || 6000);

// 设置静态文件
app.use(express.static(__dirname + '/public'));

// 设置body parser格式
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: false }));



app.use(function(req, res, next){
	res.locals.showTests = app.get('env') !== 'production' && req.query.test === '1';
    next();
});


// 设置访问路由

// app.set('views','./views');
// 惠金所提现访问页面
app.get('/hjs/hjstxa', function(req, res) { 
	res.render('hjstx.html'); 
});

//惠金所提现请求接口
app.post('/hjs/hjstx',function(req,res,next){
	console.log("123456");
	res.header("Access-Control-Allow-Origin","*");
	res.header("Access-Control-Allow-Headers", "Content-Type,Content-Length, Authorization, Accept,X-Requested-With");
	res.header("Access-Control-Allow-Methods","PUT,POST,GET,DELETE,OPTIONS");
	res.header("X-Powered-By","3.2.1");
	//if(req.method=="POST") 
	//	res.send(200);
	//else next();
	var oid = req.body.oid;
	var reqNo = req.body.reqNo;
	var template =  {
        "loanOrderId":oid,
        "redirectUrl":"http://m-yuqiu.liangkebang.com/repayment/plan", 
        "reqNo":reqNo
	};
	res.json(template);	
 });

// 定制404页面 
app.use(function(req, res){
	res.type('text/plain');
	res.status(404);
	//res.send('404 - Not Found');
	res.render('404')
});
// 定制 500 页面
app.use(function(err, req, res, next){
	console.error(err.stack);
	res.type('text/plain');
	res.status(500);
	//res.send('500 - Server Error');
	res.render('500')
});

// 监听端口
app.listen(app.get('port'), function(){
console.log('Express started on http://localhost:' + app.get('port') + '; press Ctrl-C to terminate.');});
