var express = require('express');
var app = express();
var fortune = require('./lib/fortune.js');
var about = require('./lib/about.js');
var bodyParser = require('body-parser'); 
var ding = require('./lib/dingding.js');
var time = require('silly-datetime')
// var db = require('./routes/db.js');
/* 导入mysql模块 */
var mysql = require('mysql');
var dbconfig = require('./db/DBConfig');
var userSQL = require('./db/Usersql');
var pool = mysql.createPool(dbconfig.mysql);  // 使用DBConfig.js的配置信息创建一个MySQL连接池
// 设置 handlebars 视图引擎
var handlebars = require('express3-handlebars')
            .create({ defaultLayout:'main',
            helpers: {
				section: function(name, options){ 
					if(!this._sections) this._sections = {}; 
					this._sections[name] = options.fn(this); 
					return null;
				} 
			} 
});
app.engine('handlebars', handlebars.engine);
// 设置模板类型
app.set('view engine', 'handlebars');

// 设置端口号
app.set('port', process.env.PORT || 5000);

// 设置静态文件
app.use(express.static(__dirname + '/public'));

// 设置body parser格式
app.use(bodyParser.json());
app.use(bodyParser.urlencoded({ extended: false }));



app.use(function(req, res, next){
	res.locals.showTests = app.get('env') !== 'production' && req.query.test === '1';
    next();
});


// 设置访问路由
app.get('/home/test', function(req, res){ 
	pool.getConnection(function(err, connection){
	    connection.query(userSQL.queryAll, function (err, result) {
		    if (err) {
	            console.log('数据库插入失败:' + err);
	            return;
		    }
		    // console.log(result);
			res.render('about_list',{daily_report:result})
		});
	});
});

app.get('/about', function(req, res) { 
	res.render('about'); 
});
app.get('/about_list', function(req, res) { 
	pool.getConnection(function(err, connection){
	    connection.query(userSQL.queryAll, function (err, result) {
		    if (err) {
	            console.log('数据库插入失败:' + err);
	            return;
		    }
		    // console.log(result);
			res.render('about_list',{daily_report:result})
		});
	});
});
;

app.get('/about_edit', function(req, res) { 
	pool.getConnection(function(err, connection){
		var id = req.query.id;
	    connection.query(userSQL.query_object,id, function (err, result) {
	    if (err) {
            console.log('数据库插入失败:' + err);
            return;
	    };
	    // console.log(result);

	    // console.log(result[0].progress);
        var object = result[0].object; //项目名称
        var robot_path = result[0].robot_path //钉钉机器人地址
        var progress = result[0].progress; //测试进度
        var test_object = result[0].test_object; //今日目标
        var act_situation = result[0].act_situation; //实际情况
        var tomorrow_object = result[0].tomorrow_object; //明日目标
        var bug_path = result[0].bug_path; //缺陷地址
        var bug_total = result[0].bug_total;  //总bugs数
        var bug_add = result[0].bug_add;  //新增bug
        var bug_unresolved = result[0].bug_unresolved;  //未解决bug
        var bug_resolved = result[0].bug_resolved;  //已解决bug
        var bug_close = result[0].bug_close //已完成bug
        var fisk = result[0].fisk; //风险描述
        var noissue = result[0].noissue;  //严重未解决问题
        var created_at = result[0].created_at;
        var updated_at = result[0].updated_at;

	    // console.log(test_object,act_situation);
		res.render('about_edit', {
			id:id,
			object:object,
			robot_path:robot_path,
			test_object:test_object,
			act_situation:act_situation,
			tomorrow_object:tomorrow_object,
			bug_path:bug_path,
			bug_total:bug_total,
			bug_add:bug_add,
			bug_unresolved:bug_unresolved,
			bug_resolved:bug_resolved,
			bug_close:bug_close,
			fisk:fisk,
			noissue:noissue,
			created_at:created_at,
			updated_at:updated_at
		}); 
		});
	});
});


// app.post('/process', function(req, res){
//     // 这里通过 req.query 和 req.body出来表单数据
//     // console.log('Form (from querystring): ' + req.query.form);
//     // console.log('Form (from querystring): ' + req.body);

//     // console.log('CSRF token (from hidden form field): ' + req.body._csrf);
//     // console.log('Name (from visible form field): ' + req.body.name);
//     // console.log('Email (from visible form field): ' + req.body.email);
//     console.log('Email (from visible form field): ' + req.body.progress);
//     res.render('about',{name:req.body.progress});
//     // 这里303重定向到/thank-you 页面
//     // res.redirect(500, '/500'); 
// });

app.post('/daily_report_add',function(req,res){
	var object = req.body.object; //项目名称
	var robot_path = req.body.robot_path //钉钉机器人地址
	var progress = req.body.progress;   //测试进度
	var test_object = req.body.test_object;  //今日目标
	var act_situation = req.body.act_situation; //实际情况
	var tomorrow_object=req.body.tomorrow_object; //明日目标
	var bug_path = req.body.bug_path; //缺陷地址
	var bug_total = req.body.bug_total; //总bug数
	var bug_add = req.body.bug_add; //新增bug
	var bug_unresolved = req.body.bug_unresolved; //未解决bug
	var bug_resolved = req.body.bug_resolved; //已解决未验收bug
	var bug_close = req.body.bug_close //已完成bug
	var fisk= req.body.fisk; //风险描述
	var noissue = req.body.noissue; //未解决严重问题
	var created_at = time.format(new Date(), 'YYYY-MM-DD');
	var updated_at = time.format(new Date(), 'YYYY-MM-DD');

	var queryParams = {
		"object":object,
		"robot_path":robot_path,
		"progress":progress,
		"test_object":test_object,
		"act_situation":act_situation,
		"tomorrow_object":tomorrow_object,
		"bug_path":bug_path,
		"bug_total":bug_total,
		"bug_add":bug_add,
		"bug_unresolved":bug_unresolved,
		"bug_resolved":bug_resolved,
		"bug_close":bug_close,
		"fisk":fisk,
		"noissue":noissue,
		"created_at":created_at,
		"updated_at":updated_at
	};
	pool.getConnection(function(err, connection){
		var params = [queryParams.object,queryParams.robot_path,queryParams.progress,queryParams.test_object,queryParams.act_situation,queryParams.tomorrow_object,queryParams.bug_path,queryParams.bug_total,queryParams.bug_add,queryParams.bug_unresolved,queryParams.bug_resolved,queryParams.bug_close,queryParams.fisk,queryParams.noissue,queryParams.created_at,queryParams.updated_at];
	    // 插入数据
	    connection.query(userSQL.insert, params, function (err, result) {
	    // 代码块
	    if (err) {
            console.log('数据库插入失败:' + err);
            return;
	    }
		console.log("数据库插入成功");
		// res.render('about',{name:"提交成功！"});
		res.redirect(303,'about_list');
		ding.dingding(queryParams.object);
		});
	connection.end();
	});

});

app.post('/daily_report_edit',function(req,res){
	var id = req.query.id;
	var object = req.body.object; //项目名称
	var robot_path = req.body.robot_path //钉钉机器人地址
	var progress = req.body.progress;   //测试进度
	var test_object = req.body.test_object;  //今日目标
	var act_situation = req.body.act_situation; //实际情况
	var tomorrow_object=req.body.tomorrow_object; //明日目标
	var bug_path = req.body.bug_path; //缺陷地址
	var bug_total = req.body.bug_total; //总bug数
	var bug_add = req.body.bug_add; //新增bug
	var bug_unresolved = req.body.bug_unresolved; //未解决bug
	var bug_resolved = req.body.bug_resolved; //已解决未验收bug
	var bug_close = req.body.bug_close //已完成bug
	var fisk= req.body.fisk; //风险描述
	var noissue = req.body.noissue; //未解决严重问题
	var created_at = time.format(new Date(), 'YYYY-MM-DD');
	var updated_at = time.format(new Date(), 'YYYY-MM-DD');
	// console.log('id:',id);
	var queryParams = {
		"object":object,
		"robot_path":robot_path,
		"progress":progress,
		"test_object":test_object,
		"act_situation":act_situation,
		"tomorrow_object":tomorrow_object,
		"bug_path":bug_path,
		"bug_total":bug_total,
		"bug_add":bug_add,
		"bug_unresolved":bug_unresolved,
		"bug_resolved":bug_resolved,
		"bug_close":bug_close,
		"fisk":fisk,
		"noissue":noissue,
		"created_at":created_at,
		"updated_at":updated_at
	};
	
	console.log('开始连接数据库--------------------');
	pool.getConnection(function(err, connection){	   
	    var params = [queryParams.object,queryParams.robot_path,queryParams.progress,queryParams.test_object,queryParams.act_situation,queryParams.tomorrow_object,queryParams.bug_path,queryParams.bug_total,queryParams.bug_add,queryParams.bug_unresolved,queryParams.bug_resolved,queryParams.bug_close,queryParams.fisk,queryParams.noissue,queryParams.updated_at,id];
	    console.log('params：',params)
	    // 插入数据
	    connection.query(userSQL.update_object, params, function (err, result) {
	    // 代码块
		    if (err) {
	            console.log('数据库更新失败:' + err);
	            return;
		    }
			console.log("数据库更新成功");
			//res.render('about',{name:"测试日报更新成功"});
			res.redirect(303,'about_list');

			ding.dingding(queryParams.object);
		});
	connection.end();
	});
});



//惠金所提现请求接口
app.post('/hjs/hjstx',function(req,res,next){
	res.header("Access-Control-Allow-Origin","*");
	res.header("Access-Control-Allow-Headers", "Content-Type,Content-Length, Authorization, Accept,X-Requested-With");
	res.header("Access-Control-Allow-Methods","PUT,POST,GET,DELETE,OPTIONS");
	res.header("X-Powered-By","3.2.1");
	//if(req.method=="POST") 
	//	res.send(200);
	//else next();
	var oid = req.body.oid;
	var reqNo = req.body.reqNo;
	var namespace = req.body.namespace;
	var template =  {
        "loanOrderId":oid,
        "redirectUrl":"http://m-"+namespace+".liangkebang.com/repayment/plan", 
        "reqNo":reqNo
	};
	res.json(template);
	//连接redis
	var redis   = require('redis');
	var client  = redis.createClient('6379', '127.0.0.1');	
	client.on("error", function (err) {
  		console.log("Error " + err);
	});
	client.on("connect", runSample);
	function runSample() {
		  // Set a value
    		client.set("::ffff:127.0.0.1"+oid+"hjstixiansuccess", "hjstixiansuccess", function (err, reply) {
		client.quit();
         });
         } 
});

//惠金所存管跳转请求接口
  app.post('/hjs/submitdepository',function(req,res,next){
          res.header("Access-Control-Allow-Origin","*");
          res.header("Access-Control-Allow-Headers", "Content-Type,Content-Length, Authorization, Accept,X-Requested-With");
          res.header("Access-Control-Allow-Methods","PUT,POST,GET,DELETE,OPTIONS");
          res.header("X-Powered-By","3.2.1");
          //if(req.method=="POST")
          //      res.send(200);
          //else next();
          var oid = req.body.oid;
          var reqNo = req.body.reqNo;
	  var namespace = req.body.namespace;
	  var cb = req.body.cb;
          var template =  {
          "code":0,
          "loanOrderId":oid,
          "redirectUrl":cb,
          "reqNo":reqNo
          };
          res.json(template);
	  //连接redis
	  var redis   = require('redis');
	  var client  = redis.createClient('6379', '127.0.0.1');
	  client.on("error", function (err) {
                console.log("Error " + err);
          });
          client.on("connect", runSample);
         function runSample() {
        	// Set a value
                client.set("::ffff:127.0.0.1"+oid+"hjskaihusuccess", "hjskaihusuccess", function (err, reply) {
                client.quit();
                 });
        }	
    });

// 定制404页面 
app.use(function(req, res){
	res.type('text/plain');
	res.status(404);
	//res.send('404 - Not Found');
	res.render('404')
});
// 定制 500 页面
app.use(function(err, req, res, next){
	console.error(err.stack);
	res.type('text/plain');
	res.status(500);
	//res.send('500 - Server Error');
	res.render('500')
});

// 监听端口
app.listen(app.get('port'), function(){
console.log('Express started on http://localhost:' + app.get('port') + '; press Ctrl-C to terminate.');});
