import request from '@/utils/request'

export function fetchUser(params) {
  return request({
    url: '/user/list/get',
    method: 'get',
    params
  })
}

export function fetchUserRank(params) {
  return request({
    url: '/user/rank',
    method: 'get',
    params
  })
}

export function save(data) {
  return request({
    url: '/user/add',
    method: 'post',
    data
  })
}

export function modifyUser(data) {
  return request({
    url: '/user/modify',
    method: 'put',
    data
  })
}

export function getRoles(params) {
  return request({
    url: '/role/all',
    method: 'get',
    params
  })
}

export function getRoleList(params) {
  return request({
    url: '/role/list',
    method: 'get',
    params
  })
}

export function saveRole(data) {
  return request({
    url: '/role/save',
    method: 'post',
    data
  })
}

export function modifyRole(data) {
  return request({
    url: '/role/update',
    method: 'put',
    data
  })
}

export function changePassword(data) {
  return request({
    url: '/user/update/password',
    method: 'put',
    data
  })
}
