import request from '@/utils/request'

export function getOrders(query) {
  return request({
    url: '/order/list',
    method: 'get',
    params: query
  })
}

export function approve(data) {
  return request({
    url: '/order/approve',
    method: 'post',
    data
  })
}

export function getOrderHistory(query) {
  return request({
    url: '/order/history/status',
    method: 'get',
    params: query
  })
}

export function cancelLoan(data) {
  return request({
    url: '/order/cancel/loan',
    method: 'post',
    data
  })
}

export function lendLoan(data) {
  return request({
    url: '/order/lending',
    method: 'post',
    data
  })
}

export function callbackRecord(query) {
  return request({
    url: '/order/orderCallbackRecordList',
    method: 'get',
    params: query
  })
}

export function logHistory(query) {
  return request({
    url: '/opt/history/log/all',
    method: 'get',
    params: query
  })
}
