import request from '@/utils/request'

export function getChannels(data) {
  return request({
    url: '/channel/info',
    method: 'post',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    },
    params: data
  })
}

export function getChannelInfo(params) {
  return request({
    url: '/channel/all',
    method: 'get',
    params
  })
}

export function saveChannel(data) {
  return request({
    url: '/channel/cfg/info',
    method: 'post',
    data
  })
}

export function getChannelDetail(query) {
  return request({
    url: '/channel/cfg/info',
    method: 'get',
    params: query
  })
}
