import request from '@/utils/request'
import xlsx from 'xlsx'

export function getChannels(data) {
  return request({
    url: '/channel/info',
    method: 'post',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    },
    params: data
  })
}

export function getChannelInfo(params) {
  return request({
    url: '/channel/all',
    method: 'get',
    params
  })
}

export function saveChannel(data) {
  return request({
    url: '/channel/cfg/info',
    method: 'post',
    data
  })
}

export function getChannelDetail(query) {
  return request({
    url: '/channel/cfg/info',
    method: 'get',
    params: query
  })
}

export function exportExcel(postfix, data) {
  const now = new Date()
  const year = now.getFullYear()
  const month = now.getMonth() + 1
  const day = now.getDate()
  const filename = year + '-' + month + '-' + day + '-' + postfix
  // const worksheet = xlsx.utils.aoa_to_sheet(data)
  const worksheet = xlsx.utils.json_to_sheet(data)
  const newWorkbook = xlsx.utils.book_new()
  xlsx.utils.book_append_sheet(newWorkbook, worksheet, 'SheetJS')
  xlsx.writeFile(newWorkbook, filename + '.xlsx')
}

export function getChannelConf(params) {
  return request({
    url: '/channel/conf/export',
    method: 'get',
    params
  })
}
