import axios from 'axios'
import { Message } from 'element-ui'
import store from '../store'
import { getToken } from '@/utils/auth'

// 创建axios实例
const service = axios.create({
  // baseURL: process.env.BASE_API, // api 的 base_url
  withCredentials: true,
  timeout: 1000 * 10 // 请求超时时间
})

// request拦截器
service.interceptors.request.use(
  config => {
    if (store.getters.token) {
      config.headers['SESSION'] = getToken() // 让每个请求携带自定义token 请根据实际情况自行修改
    }
    const url = store.getters.env === 'qaapi' ? process.env.qaapi : process.env.BASE_API.replace('namespace', store.getters.env)
    config.url = url + config.url
    config.headers['cluster'] = 'qa'
    return config
  },
  error => {
    // Do something with request error
    console.log(error) // for debug
    Promise.reject(error)
  }
)

// response 拦截器
service.interceptors.response.use(
  // response => response.data,
  response => {
    /**
     * code为非20000是抛错 可结合自己业务进行修改
     */
    const res = response.data
    if ((typeof res.code === 'number' && res.code !== 200000) || (typeof res.code === 'string' && res.code !== '0000')) {
      Message({
        message: res.message,
        type: 'error',
        duration: 5 * 1000
      })

      // 50008:非法的token; 50012:其他客户端登录了;  500003:Token 过期了;
      if (res.code === 501002 || res.code === 500003) {
        store.dispatch('FedLogOut').then(() => {
          location.reload() // 为了重新实例化vue-router对象 避免bug
        })

        Message({
          message: 'token失效，你已被登出',
          type: 'warning',
          duration: 2000
        })
      }
      // return Promise.reject('error')
    } else {
      return response.data
    }
  },
  error => {
    console.log('err' + error) // for debug
    Message({
      message: error.message,
      type: 'error',
      duration: 5 * 1000
    })
    return Promise.reject(error)
  }
)

export default service
