package cn.qg.holmes.entity.lanzhou;

import cn.qg.holmes.encrypt.LanzhouBankEncrypt;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.Date;

@Slf4j
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BaseReq<T> {

    /**
     * 调用的终端类型
     */
    private String transcode;
    /**
     * 交易代码
     */
    private String sysid;

    /**
     * 交易时间
     */
    private String transtime;
    private String sign;

    /**
     * 终端类型
     * PC
     * WECHAT
     * ANDROID
     * IOS
     */
    private String deviceType = "PC";

    @JSONField(name = "RequestParams")
    private T t;


    public BaseReq(T t, String transcode, String md5key, String publicKey, String sysId) {
        this.t = t;
        this.transcode = transcode;
        this.transtime = DateFormatUtils.format(new Date(), "yyyyMMddHHmmss");
        this.sysid = sysId;
        this.sign = getSign(md5key);
    }


    public String getSign(String md5key) {
        return LanzhouBankEncrypt.MD5(sysid + "|" + transtime + "|" + md5key);
    }
}
