package cn.qg.holmes.entity.mock.keystone.jdbuy;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class JdOrderDetailResponse extends JdBaseResponse{

    private static final String TIME_FORMAT_YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";

    private Map<String, Object> result;


    public boolean hasChildOrder(){
        return "1".equals(result.get("type").toString());
    }


    public JdAllOrderInfo findJdAllOrderInfo(){
        JSONObject json = new JSONObject(result);
        return json.toJavaObject(JdAllOrderInfo.class);
    }

    public JdParentOrderInfo findJdParentOrderInfo() {
        JSONObject json = new JSONObject(result);
        return json.toJavaObject(JdParentOrderInfo.class);
    }

    @Data
    public static class JdParentOrderInfo{

        /**
         * 父订单号。为0时，此订单为父单
         */
        private Long pOrder;

        /**
         * 订单状态。0为取消订单  1为有效
         */
        private Integer orderState;

        /**
         * 京东订单编号
         */
        private Long jdOrderId;

        /**
         * 物流状态。0 是新建  1是妥投   2是拒收
         */
        private Integer state;

        /**
         * 预占确认状态。0没确认预占   1为确认预占
         */
        private Integer submitState;

        /**
         * 订单类型。1是父订单   2是子订单。
         */
        private Integer type;

        /**
         * 运费
         */
        private BigDecimal freight;

        /**
         * 商品列表
         */
        private List<JdOrderSkuInfo> sku;

        /**
         * 订单总金额 =商品总金额+运费
         */
        private BigDecimal orderPrice;

        /**
         * 订单未含税金额
         */
        private BigDecimal  orderNakedPrice;

        /**
         * 订单税额
         */
        private BigDecimal orderTaxPrice;

        /**
         * 订单类别 枚举如下：
         * 1.普通商品
         * 2.大家电
         * 3.实物礼品卡
         * 4.售后换新单
         * 5.厂家直送订单
         * 6.FBP订单
         * 7.生鲜
         * 20.电子卡
         * 21.机票
         * 22.酒店
         * 23.合约机号卡
         * 24.火车票
         */
        private Integer orderType;

        /**
         * 订单创建时间
         */
        @JsonFormat(timezone = "GMT+8", pattern = TIME_FORMAT_YYYYMMDDHHMMSS)
        private Date createOrderTime;

        /**
         * 订单完成时间
         */
        @JsonFormat(timezone = "GMT+8", pattern = TIME_FORMAT_YYYYMMDDHHMMSS)
        private Date finishTime;

        /**
         * 京东状态 参考枚举值如下
         *1.新单
         *2.等待支付
         *3.等待支付确认
         *4.延迟付款确认
         *5.订单暂停
         *6.店长最终审核
         *7.等待打印
         *8.等待出库
         *9.等待打包
         *10.等待发货
         *11.自提途中
         *12.上门提货
         *13.自提退货
         *14.确认自提
         *16.等待确认收货
         *17.配送退货
         *18.货到付款确认
         *19.已完成
         *21.收款确认
         *22.锁定
         *29.等待三方出库
         *30.等待三方发货
         *31.等待三方发货完成
         */
        private Integer jdOrderState;

        /**
         * 收货地址
         */
        private String address;

        /**
         * 姓名
         */
        private String name;

        /**
         * 联系方式
         */
        private String mobile;

        /**
         * 支付方式 (1：货到付款， 4：在线支付，5：公司转账， 101：金采支付，20为混合支付)
         */
        private Integer paymentType;

        /**
         * 混合支付明细
         */
        private List<JdPayDetail> payDeatails;

        /**
         * 京东配送订单的出库时间/厂家直送订单的确认发货时间
         */
        private Date outTime;

    }

    @Data
    public static class JdOrderSkuInfo{

        /**
         * 商品名称
         */
        private  String name;

        /***
         * 京东商品编号
         */
        private Long skuId;

        /**
         * 商品数量
         */
        private Integer num;

        /**
         * 京东三级分类
         */
        private Integer category;

        /**
         * 商品价格
         */
        private BigDecimal price;

        /**
         * 商品税率。例如：本参数值返回13，代表税率为“13%”
         */
        private BigDecimal tax;

        /**
         * 主商品ID
         */
        private Long oid;

        /**
         * 商品类型
         */
        private Integer type;

        /**
         * 运费拆分价格
         */
        private Integer  splitFreight;

        /**
         * 商品税额
         */
        private Integer  taxPrice;

        /**
         * 商品未含税金额
         */
        private Integer nakedPrice;
    }

    @Data
    public static class JdPayDetail{

        /**
         * 支付标记  1  个人
         */
        private String flag;

        /**
         * 支付类型  17:微信支付   101:金采支付
         */
        private String paymentType;

        /**
         * 支付金额
         */
        private BigDecimal payMoney;
    }


    @Data
    public static class JdAllOrderInfo{

        /**
         * 父订单
         */
        private JdPOrder pOrder;

        /**
         * 子订单
         */
        private List<JdCOrder> cOrder;

        /**
         * 订单状态。0为取消订单  1为有效
         */
        private Integer orderState;


        /**
         * 预占确认状态。0没确认预占   1为确认预占
         */
        private Integer submitState;

        /**
         * 订单类型。1是父订单   2是子订单。
         */
        private Integer type;

        /**
         * 订单类别 枚举如下：
         * 1.普通商品
         * 2.大家电
         * 3.实物礼品卡
         * 4.售后换新单
         * 5.厂家直送订单
         * 6.FBP订单
         * 7.生鲜
         * 20.电子卡
         * 21.机票
         * 22.酒店
         * 23.合约机号卡
         * 24.火车票
         */
        private Integer orderType;

        /**
         * 订单创建时间
         */
        @JsonFormat(timezone = "GMT+8", pattern = TIME_FORMAT_YYYYMMDDHHMMSS)
        private Date createOrderTime;

        /**
         * 订单完成时间
         */
        @JsonFormat(timezone = "GMT+8", pattern = TIME_FORMAT_YYYYMMDDHHMMSS)
        private Date finishTime;

        /**
         * 京东状态 参考枚举值如下
         *1.新单
         *2.等待支付
         *3.等待支付确认
         *4.延迟付款确认
         *5.订单暂停
         *6.店长最终审核
         *7.等待打印
         *8.等待出库
         *9.等待打包
         *10.等待发货
         *11.自提途中
         *12.上门提货
         *13.自提退货
         *14.确认自提
         *16.等待确认收货
         *17.配送退货
         *18.货到付款确认
         *19.已完成
         *21.收款确认
         *22.锁定
         *29.等待三方出库
         *30.等待三方发货
         *31.等待三方发货完成
         */
        private Integer jdOrderState;

        /**
         * 收货地址
         */
        private String address;

        /**
         * 姓名
         */
        private String name;

        /**
         * 联系方式
         */
        private String mobile;

        /**
         * 京东配送订单的出库时间/厂家直送订单的确认发货时间
         */
        private Date outTime;

    }

    @Data
    public static class JdPOrder{

        /**
         * 京东订单编号
         */
        private Long jdOrderId;

        /**
         * 商品列表
         */
        private List<JdOrderSkuInfo> sku;

        /**
         * 运费
         */
        private BigDecimal freight;

        /**
         * 订单总金额 =商品总金额+运费
         */
        private BigDecimal orderPrice;

        /**
         * 订单未含税金额
         */
        private BigDecimal  orderNakedPrice;

        /**
         * 订单税额
         */
        private BigDecimal orderTaxPrice;

        /**
         * 京东配送订单的出库时间/厂家直送订单的确认发货时间
         */
        private Date outTime;
    }


    @Data
    public static class JdCOrder{
        /**
         * 父订单号。为0时，此订单为父单
         */
        private Long pOrder;

        /**
         * 订单状态。0为取消订单  1为有效
         */
        private Integer orderState;

        /**
         * 京东订单编号
         */
        private Long jdOrderId;

        /**
         * 物流状态。0 是新建  1是妥投   2是拒收
         */
        private Integer state;

        /**
         * 预占确认状态。0没确认预占   1为确认预占
         */
        private Integer submitState;

        /**
         * 订单类型。1是父订单   2是子订单。
         */
        private Integer type;

        /**
         * 运费
         */
        private BigDecimal freight;

        /**
         * 商品列表
         */
        private List<JdOrderSkuInfo> sku;

        /**
         * 订单总金额 =商品总金额+运费
         */
        private BigDecimal orderPrice;

        /**
         * 订单未含税金额
         */
        private BigDecimal  orderNakedPrice;

        /**
         * 订单税额
         */
        private BigDecimal orderTaxPrice;

        /**
         * 京东配送订单的出库时间/厂家直送订单的确认发货时间
         */
        private Date outTime;
    }
}
