package cn.qg.holmes.service.jira.impl;

import cn.qg.holmes.entity.jira.DingRobot;
import cn.qg.holmes.entity.jira.JiraBugPool;
import cn.qg.holmes.mapper.jira.DingRobotMapper;
import cn.qg.holmes.service.jira.DingRobotService;
import cn.qg.holmes.service.jira.JiraBugPoolService;
import cn.qg.holmes.utils.DingdingUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jayway.jsonpath.JsonPath;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class DingRobotServiceImpl extends ServiceImpl<DingRobotMapper, DingRobot> implements DingRobotService {

    @Autowired
    DingRobotMapper dingRobotMapper;

    @Autowired
    JiraBugPoolService jiraBugPoolService;

    @Override
    public Boolean sendMsgToDing(String jiraData) {
        log.info("收到jira bug提交：{}", jiraData);
        String webhookEvent = JsonPath.read(jiraData, "$.webhookEvent");
        if (StringUtils.equals(webhookEvent, "jira:issue_created")) {
            String creator = JsonPath.read(jiraData, "$.issue.fields.creator.displayName");
            String assignee = JsonPath.read(jiraData, "$.issue.fields.assignee.displayName");
            String key = JsonPath.read(jiraData, "$.issue.key");
            String summary = JsonPath.read(jiraData, "$.issue.fields.summary");
            String priority = JsonPath.read(jiraData, "$.issue.fields.priority.name");
            String module = JsonPath.read(jiraData, "$.issue.fields.components[0].name");
            String robotUrl = null;
            List<DingRobot> dingRobots = dingRobotMapper.selectList(null);
            for (DingRobot dingRobot : dingRobots) {
                String projectName = "【" + dingRobot.getProjectName() + "】";
                if (summary.contains(projectName)) {
                    robotUrl = dingRobot.getDingUrl();
                    break;
                }
            }
            // 首次提交的BUG放入bug池子
            JiraBugPool jiraBugPool = new JiraBugPool();
            jiraBugPool.setKey(key);
            jiraBugPool.setSummary(summary);
            jiraBugPool.setPriority(priority);
            jiraBugPool.setReporter(creator);
            jiraBugPool.setAssignee(assignee);
            jiraBugPool.setUrl("http://jira2.quantgroup.cn/browse/" + key);
            jiraBugPool.setDingUrl(robotUrl);
            jiraBugPoolService.save(jiraBugPool);
            if (robotUrl != null) {
                String markdownMsg = DingdingUtils.buildMarkdownMsg(key, summary, creator, assignee, priority, module);
                return DingdingUtils.sendToDingding(markdownMsg, robotUrl);
            }
        }
        return false;
    }
}
