package cn.qg.holmes.bean;

import cn.qg.holmes.entity.mock.keystone.ProductItem;
import cn.qg.holmes.entity.mock.keystone.SupplierOrderSku;
import cn.qg.holmes.utils.JdbcUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.math.BigDecimal;
import java.sql.*;
import java.util.List;
import java.util.Map;

@Slf4j
@Component
public class KeystoneService {

    String driver = "com.mysql.jdbc.Driver";
    String dbName = "keystone";
    Connection connection = null;
    PreparedStatement preparedStatement = null;
    Statement statement = null;
    @Value("${dbsync.mysql.ip}")
    private String ip;
    @Value("${dbsync.mysql.port}")
    private String port;
    @Value("${dbsync.mysql.username}")
    private String username;
    @Value("${dbsync.mysql.password}")
    private String password;

    @PostConstruct
    public void createConnection() {
        String url = "jdbc:mysql://" + ip + ":" + port + "/" + dbName;
        try {
            Class.forName(driver);
            connection = DriverManager.getConnection(url, username, password);
            log.info("创建同步库keystone连接: {}", connection.toString());
        } catch (Exception e) {
            log.info("同步库初始化失败.");
            e.printStackTrace();
        }
    }

    /**
     * 根据id获取商品相关信息
     * @param skuId
     * @param supplierType 供应商类型
     * @return
     */
    public ProductItem getProductItemById(String skuId, String supplierType) {
        String sql = "SELECT * FROM `product_item` WHERE `third_sku_no` = " + skuId;
        log.info("从keystone.product_item根据skuId查询商品信息：{}", sql);
        ProductItem productItem = new ProductItem();
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            List<Map<String, Object>> resultList = JdbcUtils.convertResultSetToList(resultSet);
            if (resultList.size() > 0) {
                Map<String, Object> map = resultList.get(0);
                productItem.setProductId((Long) map.get("id"));
                productItem.setName((String) map.get("name"));
                productItem.setThirdSkuNo((String) map.get("third_sku_no"));
                productItem.setProductId((Long) map.get("product_id"));
                productItem.setMarketPrice(new BigDecimal(map.get("market_price").toString()));
                productItem.setSalePrice(new BigDecimal(map.get("sale_price").toString()));
                productItem.setSupplyPrice(new BigDecimal(map.get("sale_price").toString()));
                productItem.setSpecProps(map.get("spec_props").toString());
                productItem.setState((Integer) map.get("state"));
                productItem.setOffSaleItemId((Long) map.get("off_sale_item_id"));
                productItem.setImage((String) map.get("image"));
                productItem.setPrimaryImage((String) map.get("primary_image"));
                productItem.setProductStockWarning((Integer) map.get("product_stock_warning"));
                productItem.setSupplierType((String) map.get("supplier_type"));
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.info("从keystone.product_item根据skuId查询商品信息异常！");
        }
        return productItem;
    }

    /**
     * 根据京东订单号获取数据
     * @param supplierOrderNo
     * @return
     */
    public SupplierOrderSku getSupplierOrderSkuBySupplierOrderNo(String supplierOrderNo) {
        String sql = "SELECT * FROM `supplier_order_sku` WHERE `supplier_order_no` = " + supplierOrderNo;
        log.info("从keystone.supplier_order_sku查询信息：{}", sql);
        SupplierOrderSku supplierOrderSku = new SupplierOrderSku();
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            List<Map<String, Object>> resultList = JdbcUtils.convertResultSetToList(resultSet);
            if (resultList.size() > 0) {
                Map<String, Object> map = resultList.get(0);
                supplierOrderSku.setSupplierOrderNo(map.get("supplier_order_no").toString());
                supplierOrderSku.setSkuNo(map.get("sku_no").toString());
                supplierOrderSku.setSkuName(map.get("sku_name").toString());
                supplierOrderSku.setImageUrl(map.get("image_url").toString());
                supplierOrderSku.setPrice(new BigDecimal(map.get("price").toString()));
                supplierOrderSku.setCount(Integer.valueOf(map.get("count").toString()));
                supplierOrderSku.setState(Integer.valueOf(map.get("state").toString()));
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.info("从keystone.supplier_order_sku查询信息异常！");
        }
        return supplierOrderSku;
    }
}
