package cn.qg.holmes.controller.auto;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auto.SceneTestcase;
import cn.qg.holmes.service.auto.SceneTestcaseService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/auto/sceneTestcase")
public class SceneTestcaseController {

    @Autowired
    SceneTestcaseService sceneTestcaseService;

    /**
     * 获取场景用例列表
     * @param projectId 项目id，不传表示获取所有项目场景用例
     * @param pageNum 第几页
     * @param pageSize 每页展示多少个
     * @return
     */
    @GetMapping("/list")
    public JsonResult getSceneTestcaseList(Integer projectId,
                                           @RequestParam(defaultValue = "1") Integer pageNum,
                                           @RequestParam(defaultValue = "10") Integer pageSize) {
        IPage<SceneTestcase> sceneTestcaseIPage = sceneTestcaseService.getSceneTestcaseList(projectId, pageNum, pageSize);
        Map<String, Object> map = new HashMap<>();
        map.put("total", sceneTestcaseIPage.getTotal());
        map.put("list", sceneTestcaseIPage.getRecords());
        return JsonResult.buildSuccessResult(map);
    }

    /**
     * 新增场景用例
     * @param sceneTestcaseList 场景用例列表
     * @return
     */
    @PostMapping("/add")
    public JsonResult addSceneTestcase(@RequestBody List<SceneTestcase> sceneTestcaseList) {
        // 首先查询表里是否已有相应的数据
        for (SceneTestcase sceneTestcase: sceneTestcaseList) {
            if (sceneTestcase.getSceneId() == null) {
                return JsonResult.buildErrorStateResult("场景id不能为空！", false);
            }
            if (sceneTestcase.getSequence() == null) {
                return JsonResult.buildErrorStateResult("用例顺序不能为空！", false);
            }
            if (sceneTestcase.getInterfaceId() == null) {
                return JsonResult.buildErrorStateResult("接口id不能为空！", false);
            }
            QueryWrapper<SceneTestcase> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("scene_id", sceneTestcase.getSceneId());
            queryWrapper.eq("sequence", sceneTestcase.getSequence());
            if (sceneTestcaseService.getOne(queryWrapper) != null) {
                return JsonResult.buildErrorStateResult("场景用例已存在！", false);
            }
        }
        for (SceneTestcase sceneTestcase: sceneTestcaseList) {
            sceneTestcaseService.save(sceneTestcase);
        }
        return JsonResult.buildSuccessResult(true);
    }

    /**
     * 批量修改场景用例列表
     * @param sceneTestcaseList 场景用例列表
     * @return
     */
    @PostMapping("/modify")
    public JsonResult modifySceneTestcase(@RequestBody List<SceneTestcase> sceneTestcaseList) {
        return JsonResult.buildSuccessResult(sceneTestcaseService.updateBatchById(sceneTestcaseList));
    }

    /**
     * 删除单个场景用例
     * @param sceneTestcaseId 单个场景用例id
     * @return
     */
    @GetMapping("/delete")
    public JsonResult deleteSceneTestcase(@RequestParam Integer sceneTestcaseId) {
        if (sceneTestcaseService.getById(sceneTestcaseId) == null) {
            return JsonResult.buildErrorStateResult("场景用例不存在！", false);
        }
        return JsonResult.buildSuccessResult(sceneTestcaseService.removeById(sceneTestcaseId));
    }
}
