package cn.qg.holmes.quartz;

import cn.qg.holmes.entity.monitor.SqlMonitorDataSource;
import cn.qg.holmes.service.monitor.SqlMonitorDataSourceService;
import cn.qg.holmes.service.monitor.SqlMonitorTaskService;
import cn.qg.holmes.utils.DingdingUtils;
import cn.qg.holmes.utils.JdbcUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.QuartzJobBean;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * SQL定时任务类
 * @author libo
 */
@Slf4j
public class SqlMonitorHandler extends QuartzJobBean {

    @Autowired
    SqlMonitorDataSourceService sqlMonitorDataSourceService;

    @Autowired
    SqlMonitorTaskService sqlMonitorTaskService;

    @Override
    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDetail jobDetail = jobExecutionContext.getJobDetail();
        // 定时任务名称
        String taskName = jobDetail.getKey().getName();
        // 获取定时任务信息
        QueryWrapper<cn.qg.holmes.entity.monitor.SqlMonitorTask> monitorTaskQueryWrapper = new QueryWrapper<>();
        monitorTaskQueryWrapper.eq("task_name", taskName);
        cn.qg.holmes.entity.monitor.SqlMonitorTask sqlMonitorTask = sqlMonitorTaskService.getOne(monitorTaskQueryWrapper);
        // 获取数据源相关信息
        Integer dsId = sqlMonitorTask.getDsId();
        SqlMonitorDataSource sqlMonitorDataSource = sqlMonitorDataSourceService.getById(dsId);

        List<Map<String, Object>> resultList = JdbcUtils.queryForList(sqlMonitorDataSource.getHost(), sqlMonitorDataSource.getPort(),
                sqlMonitorDataSource.getUsername(), sqlMonitorDataSource.getPassword(), null, sqlMonitorTask.getSql());
        String dingUrl = sqlMonitorTask.getDingUrl();
        String dingText = sqlMonitorTask.getDingText();
        if (resultList != null) {
            dingText = replaceDingText(dingText, resultList);
        }
        String markdownMsg = DingdingUtils.buildMarkdownMsg("监控测试", dingText + "\n" + JSON.toJSONString(resultList), false);
        DingdingUtils.sendToDingding(markdownMsg, dingUrl);
    }

    public static String replaceDingText(String dingText, List<Map<String, Object>> queryList) {
        // 替换{count}
        if (dingText.contains("{count}")) {
            dingText = dingText.replace("{count}", String.valueOf(queryList.size()));
        }
        // 正则表达式替换{数字}，当前仅替换第一行的数据，{0}为第一行第一列，{1}第一行第二列，以此类推...
        String regex = "\\{([^}]*)\\}";
        Pattern numPattern = Pattern.compile(regex);
        Matcher matcher = numPattern.matcher(dingText);
        List<String> firstLineDataList = null;
        if (queryList.size() > 0) {
            firstLineDataList = new ArrayList(queryList.get(0).values());
        }

        while (matcher.find()) {
            String matchString = matcher.group();
            int index = Integer.parseInt(matchString.substring(1, matchString.length() -1));
            if (firstLineDataList != null && firstLineDataList.size() > index) {
                dingText = dingText.replace(matchString, firstLineDataList.get(index));
            } else {
                dingText = dingText.replace(matchString, "NULL");
            }
        }
        return dingText;
    }

    public static void main(String[] args) {
        String dingText = "监控定时任务测试，本次共查出{count}条数据，第一行第一列数据是{0}啦啦啦, 第一行第二列数据是{1},第一行第三列数据是{2}";
        List<Map<String, Object>> mapList = new ArrayList<>();
        Map<String, Object> map1 = new LinkedHashMap<>();
        Map<String, Object> map2 = new LinkedHashMap<>();
        map1.put("sku_no", "123");
        map1.put("sku_name", "商品一");
        map2.put("sku_no", "456");
        map2.put("sku_name", "商品二");
        mapList.add(map1);
        mapList.add(map2);
        System.out.println(mapList);
        dingText = replaceDingText(dingText, mapList);
        System.out.println(dingText);
    }
}
