package cn.qg.holmes.controller.auth;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auth.Role;
import cn.qg.holmes.entity.auth.RolePermission;
import cn.qg.holmes.entity.auth.RolePermissionVo;
import cn.qg.holmes.service.auth.RolePermissionService;
import cn.qg.holmes.service.auth.RoleService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@CrossOrigin
@RestController
@RequestMapping("/role/permission")
public class RolePermissionController {

    @Autowired
    RolePermissionService rolePermissionService;

    @Autowired
    RoleService roleService;

    /**
     * 新增角色权限
     * @return
     */
    @PostMapping("/add")
    public JsonResult addRolePermission(@RequestBody RolePermissionVo rolePermissionVo) {
        String roleName = rolePermissionVo.getRoleName();
        List<Integer> permissionIdList = rolePermissionVo.getPermissionIdList();
        QueryWrapper<Role> roleQueryWrapper = new QueryWrapper<>();
        roleQueryWrapper.eq("role_name", roleName);
        if (roleService.getOne(roleQueryWrapper) != null) {
            return JsonResult.buildErrorStateResult("角色名已存在！", false);
        }
        Role role = new Role();
        role.setRoleName(rolePermissionVo.getRoleName());
        boolean result = roleService.save(role);
        if (!result) {
            return JsonResult.buildErrorStateResult("新建角色失败！", false);
        }
        Role newRole = roleService.getOne(roleQueryWrapper);
        Integer roleId = newRole.getId();

        List<RolePermission> rolePermissionList = new ArrayList<>();
        for (Integer permissionId: permissionIdList) {
            RolePermission rolePermission = new RolePermission();
            rolePermission.setRoleId(roleId);
            rolePermission.setPermissionId(permissionId);
            rolePermissionList.add(rolePermission);
        }
        return JsonResult.buildSuccessResult(rolePermissionService.saveBatch(rolePermissionList));
    }

    /**
     * 编辑角色权限
     * @return
     */
    @PostMapping("/edit")
    public JsonResult editRolePermission(RolePermissionVo rolePermissionVo) {
//        Integer roleId = rolePermissionVo.getRoleId();
//        List<Integer> permissionIdList = rolePermissionVo.getPermissionIdList();
//        QueryWrapper<RolePermission> rolePermissionQueryWrapper = new QueryWrapper<>();
//        rolePermissionQueryWrapper.eq("role_id", roleId);
//        List<RolePermission> rolePermissionListDb = rolePermissionService.list(rolePermissionQueryWrapper);
//        for (RolePermission rolePermissionDb: rolePermissionListDb) {
//            boolean flag = false;
//            for (Integer permissionId: permissionIdList) {
//                rolePermissionQueryWrapper.eq("permission_id", permissionId);
//                RolePermission rolePermission = rolePermissionService.getOne(rolePermissionQueryWrapper);
//                if (rolePermission == null) {
//
//                }
//                if (rolePermission != null && rolePermission.getId().equals(rolePermissionDb.getPermissionId())) {
//                    flag = true;
//                    break;
//                }
//            }
//            if (!flag) {
//                rolePermissionService.removeById(rolePermissionDb.getId());
//            }
//        }
//        return JsonResult.buildSuccessResult(rolePermissionService.saveOrUpdateBatch(rolePermissionList));
        return null;
    }

    /**
     * 删除角色权限
     * @param rolePermissionId 角色权限
     * @return
     */
    @GetMapping("/del")
    public JsonResult delRolePermission(Integer rolePermissionId) {
        return JsonResult.buildSuccessResult(rolePermissionService.removeById(rolePermissionId));
    }
}
