package cn.qg.holmes.aspect;

import cn.qg.holmes.config.annotation.RecordOperation;
import cn.qg.holmes.entity.behavior.UserBehaviorRecord;
import cn.qg.holmes.entity.k8s.ServiceCreateVo;
import cn.qg.holmes.exception.UnauthorizedException;
import cn.qg.holmes.mapper.behavior.UserBehaviorRecordMapper;
import cn.qg.holmes.service.auth.TokenService;
import cn.qg.holmes.service.behavior.UserBehaviorRecordService;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

/**
 * 用户行为记录切面
 * @author libo
 */
@Slf4j
@Aspect
@Component
public class RecordOperationAspect {

    @Autowired
    TokenService tokenService;

    @Autowired
    UserBehaviorRecordService userBehaviorRecordService;

    @After("@annotation(cn.qg.holmes.config.annotation.RecordOperation)")
    public void after(JoinPoint joinPoint) {
        // 获取token，并根据token获取到用户名
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String token = request.getHeader("token");
        if (token == null) {
            throw new UnauthorizedException();
        }

        String username = tokenService.getUserInfoFromCache(token).getUsername();
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature) signature;
        RecordOperation recordOperation = methodSignature.getMethod().getAnnotation(RecordOperation.class);
        // 行为记录需要保存的值
        String action = recordOperation.value();
        String namespace = "";
        String serviceName = "";
        // 获取方法里的参数
        Object[] args = joinPoint.getArgs();
        ParameterNameDiscoverer pnd = new DefaultParameterNameDiscoverer();
        Method method = methodSignature.getMethod();
        String[] parameterNames = pnd.getParameterNames(method);
        if (parameterNames != null) {
            for (int i=0; i < parameterNames.length; i++)  {
                if (parameterNames[i].equals("serviceName")) {
                    serviceName = args[i].toString();
                }
                if (parameterNames[i].equals("namespace")) {
                    namespace = args[i].toString();
                }
                if  (parameterNames[i].equals("ServiceCreateVo")) {
                    ServiceCreateVo serviceCreateVo = (ServiceCreateVo) args[i];
                    serviceName = serviceCreateVo.getServiceName();
                    namespace = serviceCreateVo.getNamespace();
                }
            }
        }

        // 保存用户行为记录
        UserBehaviorRecord userBehaviorRecord = new UserBehaviorRecord();
        userBehaviorRecord.setUsername(username);
        userBehaviorRecord.setAction(action);
        userBehaviorRecord.setNamespace(namespace);
        userBehaviorRecord.setServiceName(serviceName);
        userBehaviorRecordService.save(userBehaviorRecord);
    }
}
