package cn.qg.holmes.service.k8s;

import cn.qg.holmes.utils.HttpClientUtils;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Component
public class MqService {

    /**
     * 获取MQ信息
     * @param host
     * @param auth
     * @return
     */
    public Map<String, Object> getDefinitionsOfHost(String host, String auth) {
        Map<String, String> headers = new HashMap<>();
        headers.put("Authorization", auth);
        String response = HttpClientUtils.doGet(host + "/api/definitions", headers, null);
        return JSON.parseObject(response, Map.class);
    }

    /**
     * 同步线上MQ到测试
     * @param host
     * @return
     */
    public boolean setDefinitions(String host) {
        try {
            String ONLINE_MQ_URL = "http://172.30.3.140:15672";
            String ONLINE_MQ_AUTH = "Basic cmFiYml0X2FkbWluOmFiYzEyMzQ=";
            Map<String, Object> onlineDefinitions = getDefinitionsOfHost(ONLINE_MQ_URL, ONLINE_MQ_AUTH);
            List<Map<String, String>> permissionList = (List<Map<String, String>>) onlineDefinitions.get("permissions");
            List<Map<String, String>> qaPermissionList = new ArrayList<>();
            for (Map<String, String> permission: permissionList) {
                if (permission.get("user").equals("rabbit_admin")) {
                    qaPermissionList.add(permission);
                    permission.put("user", "qa");
                    qaPermissionList.add(permission);
                }
                if (!permission.get("user").equals("qa") && !permission.get("user").equals("rabbit_admin")) {
                    qaPermissionList.add(permission);
                }
            }
            onlineDefinitions.put("permissions", qaPermissionList);
            String QA_MQ_AUTH = "Basic cWE6cWF0ZXN0";
            String qaMqUrl = "http://" + host + "/api/definitions";
            Map<String, String> headers = new HashMap<>();
            headers.put("Authorization", QA_MQ_AUTH);
            headers.put("Content-Type", "application/json");
            HttpClientUtils.doPostJson(qaMqUrl, headers, JSON.toJSONString(JSON.toJSONString(onlineDefinitions)));
            log.info("MQ同步成功：{}", host);
            return true;
        } catch (Exception e) {
            log.info("MQ同步失败：{}", host);
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        MqService mqService = new MqService();
        mqService.setDefinitions("172.17.5.17:31426");
    }
}
