package cn.qg.holmes.aspect;

import cn.qg.holmes.config.annotation.RecordOperation;
import cn.qg.holmes.entity.auth.UserInfoVo;
import cn.qg.holmes.entity.k8s.ServiceCreateVo;
import cn.qg.holmes.exception.UnauthorizedException;
import cn.qg.holmes.mapper.behavior.UserBehavoirRecordMapper;
import cn.qg.holmes.service.auth.TokenService;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Parameter;

/**
 * 用户行为记录切面
 * @author libo
 */
@Slf4j
@Aspect
@Component
public class RecordOperationAspect {

    @Autowired
    TokenService tokenService;

    @Autowired
    UserBehavoirRecordMapper userBehavoirRecordMapper;

    @After("@annotation(cn.qg.holmes.config.annotation.RequiresPermissions)")
    public void after(JoinPoint joinPoint) {
        // 获取token，并根据token获取到用户名
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String token = request.getHeader("token");
        if (token == null) {
            throw new UnauthorizedException();
        }

        String username = tokenService.getUserInfoFromCache(token).getUsername();
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature) signature;
        RecordOperation recordOperation = methodSignature.getMethod().getAnnotation(RecordOperation.class);
        String action = recordOperation.value();
        String namespace;
        String serviceName;
        Parameter[] parameters = methodSignature.getMethod().getParameters();
        if (parameters.length > 0) {
            for (int i=0; i < parameters.length; i++) {
                if (parameters[i].getName().equals("namespace")) {
                    namespace = parameters[i].getName();
                }
                if (parameters[i].getName().equals("serviceName")) {
                    serviceName = parameters[i].getName();
                }
                if (parameters[i].getParameterizedType().getTypeName().contentEquals("ServiceCreateVo")) {

                }
            }
        }
    }
}
