package cn.qg.holmes.service.k8s;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

@Slf4j
@Component
public class RedisService {

    /**
     * 清空redis
     * @param redisHost redis host
     * @param redisPort redis port
     * @return
     */
    public boolean flushRedis(String redisHost, Integer redisPort) {
        try {
            Jedis jedis = new Jedis(redisHost, redisPort);
            jedis.flushAll();
            jedis.quit();
            jedis.close();
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

}
