package cn.qg.holmes.controller.effect;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.service.effect.DatabaseSyncService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/db/sync")
public class DbSyncController {

    @Autowired
    DatabaseSyncService databaseSyncService;

    @Value("${dbsync.mysql.ip}")
    private String ip;

    @Value("${dbsync.mysql.port}")
    private String port;

    @Value("${dbsync.mysql.username}")
    private String username;

    @Value("${dbsync.mysql.password}")
    private String password;

    @GetMapping("/db")
    public JsonResult syncSingleDatabase(@RequestParam String namespace, @RequestParam String dbName) {
        long startTime = System.currentTimeMillis();
        databaseSyncService.getDbInfoFromSource(ip, port, username, password, dbName);
        Map<String, String> map = databaseSyncService.getMysqlInfoByNamespace(namespace);
        String destIp = map.get("ip");
        String destPort = map.get("port");
        databaseSyncService.syncDbToDest(destIp, destPort, "qa", "qatest", dbName);
        long endTime = System.currentTimeMillis();
        return JsonResult.buildSuccessResult((endTime - startTime) / 1000);
    }

    @GetMapping("/table")
    public JsonResult syncSingleTable(@RequestParam String namespace, @RequestParam String dbName, @RequestParam String tableName) {
        long startTime = System.currentTimeMillis();
        Map<String, String> map = databaseSyncService.getMysqlInfoByNamespace(namespace);
        String destIp = map.get("ip");
        String destPort = map.get("port");
        databaseSyncService.getSingleTableFromSource(ip, port, username, password, dbName, tableName);
        databaseSyncService.syncSingleTableToDest(destIp, destPort, "qa", "qatest", dbName, tableName);
        long endTime = System.currentTimeMillis();
        return JsonResult.buildSuccessResult((endTime - startTime) / 1000);
    }

    /**
     * 获取数据库列表
     * @return
     */
    @GetMapping("/dblist")
    public JsonResult getDatabaseList() {
        return JsonResult.buildSuccessResult(databaseSyncService.getDatabaseList(ip, port, username, password));
    }


    /**
     * 获取某个库下的表列表
     * @param dbName
     * @return
     */
    @GetMapping("/tablelist")
    public JsonResult getTableList(@RequestParam String dbName) {
        return JsonResult.buildSuccessResult(databaseSyncService.getTableListByDb(ip, port, username, password, dbName));
    }
}
