package cn.qg.holmes.controller.effect;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.service.effect.DatabaseSyncService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/db")
public class DbSyncController {

    @Autowired
    DatabaseSyncService databaseSyncService;

    @Value("${dbsync.mysql.ip}")
    private String ip;

    @Value("${dbsync.mysql.port}")
    private String port;

    @Value("${dbsync.mysql.username}")
    private String username;

    @Value("${dbsync.mysql.password}")
    private String password;

    @GetMapping("/sync/one")
    public JsonResult syncSingleDatabase(@RequestParam String namespace, @RequestParam String dbName) {
        long startTime = System.currentTimeMillis();
        databaseSyncService.getDbInfoFromSource(ip, port, username, password, dbName);
        Map<String, String> map = databaseSyncService.getMysqlInfoByNamespace(namespace);
        String destIp = map.get("ip");
        String destPort = map.get("port");
        databaseSyncService.syncDbToDest(destIp, destPort, "qa", "qatest", dbName);
        long endTime = System.currentTimeMillis();
        return JsonResult.buildSuccessResult((endTime - startTime) / 1000);
    }

    /**
     * 获取数据库列表
     * @return
     */
    @GetMapping("/sync/list")
    public JsonResult getDatabaseList() {
        return JsonResult.buildSuccessResult(databaseSyncService.getDatabaseList(ip, port, username, password));
    }
}
