package cn.qg.holmes.controller.gitlab;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.k8s.DockerProject;
import cn.qg.holmes.service.k8s.DockerProjectService;
import cn.qg.holmes.utils.GitlabService;
import cn.qg.holmes.utils.HttpClientUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

@CrossOrigin
@RestController
@RequestMapping("/gitlab")
public class GitlabController {

    @Autowired
    GitlabService gitlabService;

    @Autowired
    DockerProjectService dockerProjectService;

    /**
     * 获取项目名列表
     * @return
     */
    @GetMapping("/projects")
    public JsonResult getProjectsList() {
//        String baseUrl = "http://qaapi.liangkebang.com/proconfig/get_project_for_jenkins?type=";
//        String javaResult = HttpClientUtils.doGet(baseUrl + "java");
//        String uiResult = HttpClientUtils.doGet(baseUrl + "ui");
//        String nodeResult = HttpClientUtils.doGet(baseUrl + "node");
//        List<String> javaList = Arrays.asList(javaResult.split("\n"));
//        List<String> uiList = Arrays.asList(uiResult.split("\n"));
//        List<String> nodeList = Arrays.asList(nodeResult.split("\n"));
//        List<Map<String, String>> serviceList = new ArrayList<>();
//        for (String service: javaList) {
//            Map<String, String> map = new HashMap<>();
//            map.put("name", service);
//            map.put("type", "java");
//            serviceList.add(map);
//        }
//        for (String service: uiList) {
//            Map<String, String> map = new HashMap<>();
//            map.put("name", service);
//            map.put("type", "ui");
//            serviceList.add(map);
//        }
//        for (String service: nodeList) {
//            Map<String, String> map = new HashMap<>();
//            map.put("name", service);
//            map.put("type", "node");
//            serviceList.add(map);
//        }
//        return JsonResult.buildSuccessResult(serviceList);

        List<Map<String, String>> serviceList = new ArrayList<>();
        QueryWrapper<DockerProject> dockerProjectQueryWrapper = new QueryWrapper<>();
        dockerProjectQueryWrapper
                .eq("is_active", 1)
                .eq("project_type", "java")
                .orderByAsc("project_name");
        List<DockerProject> dockerProjectList = dockerProjectService.list(dockerProjectQueryWrapper);
        for (DockerProject dockerProject: dockerProjectList) {
            Map<String, String> map = new HashMap<>();
            map.put("name", dockerProject.getProjectName());
            map.put("type", dockerProject.getProjectType());
            serviceList.add(map);
        }
        dockerProjectQueryWrapper.clear();
        dockerProjectList.clear();
        dockerProjectQueryWrapper
                .eq("is_active", 1)
                .eq("project_type", "ui")
                .orderByAsc("project_name");
        dockerProjectList = dockerProjectService.list(dockerProjectQueryWrapper);
        for (DockerProject dockerProject: dockerProjectList) {
            Map<String, String> map = new HashMap<>();
            map.put("name", dockerProject.getProjectName());
            map.put("type", dockerProject.getProjectType());
            serviceList.add(map);
        }
        dockerProjectQueryWrapper.clear();
        dockerProjectList.clear();
        dockerProjectQueryWrapper
                .eq("is_active", 1)
                .eq("project_type", "node")
                .orderByAsc("project_name");
        dockerProjectList = dockerProjectService.list(dockerProjectQueryWrapper);
        for (DockerProject dockerProject: dockerProjectList) {
            Map<String, String> map = new HashMap<>();
            map.put("name", dockerProject.getProjectName());
            map.put("type", dockerProject.getProjectType());
            serviceList.add(map);
        }
        return JsonResult.buildSuccessResult(serviceList);
    }

    /**
     * 根据项目名获取分支列表
     * @param projectName 项目名
     * @return
     */
    @GetMapping("/branches")
    public JsonResult getBranchesByProject(String projectName) {
        List<Map<String, Object>> projectList = gitlabService.getProjectByRestApi(projectName);
        Integer projectId = null;
        for (Map<String, Object> project: projectList) {
            if (project.get("name").toString().equals(projectName) || project.get("path").toString().equals(projectName)) {
                projectId = (Integer) project.get("id");
            }
        }
        return JsonResult.buildSuccessResult(gitlabService.getBranchesByProjectId(projectId));
//        String url = "https://qaapi.liangkebang.com/pipeline/getGitBranch?name=" + projectName;
//        return JsonResult.buildSuccessResult(JSON.parseObject(HttpClientUtils.doGet(url), Map.class));
    }
}
