package cn.qg.holmes.controller.navigate;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.navigate.NavigateDetail;
import cn.qg.holmes.entity.navigate.NavigateModule;
import cn.qg.holmes.service.navigate.NavigateDetailService;
import cn.qg.holmes.service.navigate.NavigateModuleService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 导航controller
 * @author libo
 */
@CrossOrigin
@RestController
@RequestMapping("/navigate")
public class NavigateController {

    @Autowired
    NavigateModuleService navigateModuleService;

    @Autowired
    NavigateDetailService navigateDetailService;

    /**
     * 获取导航列表
     * @return
     */
    @GetMapping("/list")
    public JsonResult getNavigatelist() {
        List<Map<String, Object>> resultList = new ArrayList<>();
        List<NavigateModule> navigateModuleList = navigateModuleService.list();
        QueryWrapper<NavigateDetail> detailQueryWrapper = new QueryWrapper<>();
        for (NavigateModule navigateModule: navigateModuleList) {
            Map<String, Object> map = new HashMap<>();
            Integer moduleId = navigateModule.getId();
            detailQueryWrapper.eq("module", moduleId);
            List<NavigateDetail> navigateDetailList = navigateDetailService.list(detailQueryWrapper);
            map.put("moduleId", moduleId);
            map.put("moduleName", navigateModule.getName());
            map.put("type", navigateModule.getColor());
            map.put("list", navigateDetailList);
            resultList.add(map);
        }
        return JsonResult.buildSuccessResult(resultList);
    }
}
