package cn.qg.holmes.task;

import cn.hutool.core.io.FileUtil;
import cn.qg.holmes.entity.reconciliation.AliPayBillData;
import cn.qg.holmes.entity.reconciliation.WxPayBillData;
import cn.qg.holmes.service.reconciliation.AliPayBillService;
import cn.qg.holmes.service.reconciliation.WxPayBillService;
import cn.qg.holmes.utils.DateUtils;
import cn.qg.holmes.utils.DingdingUtils;
import cn.qg.holmes.utils.JdbcUtils;
import com.alipay.api.AlipayApiException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 对账相关定时任务
 * @author libo
 * 2022-02-21
 */
@Slf4j
@Component
public class ReconciliationTask {

    /**
     * 脱敏库相关信息
     */
    private final String DB_HOST = "172.30.5.27";
    private final String DB_PORT = "7434";
    private final String USERNAME = "haiyuan.wen";
    private final String PASSWORD = "QKawjtLXHXFVdars";

    @Autowired
    WxPayBillService wxPayBillService;

    @Autowired
    AliPayBillService aliPayBillService;

    /**
     * 对账机器人webhook
     */
    @Value("${reconciliation.ding.url}")
    private String reconciliationDingUrl;

    /**
     * 是否启动定时任务，true-启动，false-不启动
     */
    @Value("${scheduled.task.start}")
    private String scheduledTaskStart;

    /**
     * 微信商户后台与支付中心数据对账
     */
//    @Scheduled(cron = "0 */5 * * * ?")
//    @Scheduled(cron = "0 0 13 ? * *")
    public void wxPayDailyReconciliation() {
        if (scheduledTaskStart.equals("true")) {
            log.info("开始微信支付对账.");
            String payOrderSql = "SELECT * FROM pay_channel_order " +
                    "WHERE updated_at > (SELECT DATE_SUB(CURDATE(), INTERVAL 1 DAY)) AND updated_at < CURDATE() " +
                    "AND pay_approach IN (77, 83) " +
                    "AND pay_status=3";
            String refundOrderSql = "SELECT * FROM refund_order " +
                    "WHERE updated_at > (SELECT DATE_SUB(CURDATE(), INTERVAL 1 DAY)) " +
                    "AND updated_at < CURDATE() " +
                    "AND channel_account_id='86' " +
                    "AND refund_status=4";

            List<Map<String, Object>> payOrderList = JdbcUtils.queryForList(DB_HOST, DB_PORT, USERNAME, PASSWORD, "vpayment_center", payOrderSql);
            List<Map<String, Object>> refundOrderList = JdbcUtils.queryForList(DB_HOST, DB_PORT, USERNAME, PASSWORD, "vpayment_center", refundOrderSql);

            // 从微信商户后台获取数据
            String billDate = DateUtils.convertDate(DateUtils.getBeforeDay(new Date(), 1), "yyyyMMdd");
            String billType = "SUCCESS"; // 仅支付
            List<WxPayBillData> payBillDataList = wxPayBillService.parseTradeBill(wxPayBillService.downloadTradeBillFile(billDate, billType), billType);
            billType = "REFUND"; // 仅退款
            List<WxPayBillData> refundBillDataList = wxPayBillService.parseTradeBill(wxPayBillService.downloadTradeBillFile(billDate, billType), billType);

            // 对比交易数据，微信商户后台有，但是支付中心数据库中没有的数据列表
            BigDecimal wxTradeAmount = new BigDecimal(0);
            List<WxPayBillData> notInPayCenterTradeList = new ArrayList<>();
            for (WxPayBillData wxTradeBillData: payBillDataList) {
                String merchantOrderNo = wxTradeBillData.getMerchantOrderNo();
                String orderAmount = wxTradeBillData.getOrderAmount();
                wxTradeAmount = wxTradeAmount.add(new BigDecimal(orderAmount));
                boolean flag = false;
                for (Map<String, Object> map: payOrderList) {
                    if (StringUtils.equals(map.get("call_flow_no").toString(), merchantOrderNo)
                            && StringUtils.equals(map.get("amount").toString(), orderAmount)) {
                        flag = true;
                    }
                }

                if (!flag) {
                    notInPayCenterTradeList.add(wxTradeBillData);
                }
            }

            // 对比交易数据，支付中心有，但是微信商户后台没有
            BigDecimal payCenterTradeAmount = new BigDecimal(0);
            List<Map<String, Object>> notInWxTradeList = new ArrayList<>();
            for (Map<String, Object> map: payOrderList) {
                String callFlowNo = map.get("call_flow_no").toString();
                String amount = map.get("amount").toString();
                payCenterTradeAmount = payCenterTradeAmount.add(new BigDecimal(amount));
                boolean flag = false;
                for (WxPayBillData wxTradeBillData: payBillDataList) {
                    if (StringUtils.equals(callFlowNo, wxTradeBillData.getMerchantOrderNo())
                            && StringUtils.equals(amount, wxTradeBillData.getOrderAmount())) {
                        flag = true;
                    }
                }

                if (!flag) {
                    notInWxTradeList.add(map);
                }
            }

            // 对比退款数据，微信商户后台有，但是支付中心数据库中没有的数据列表
            BigDecimal wxRefundAmount = new BigDecimal(0);
            List<WxPayBillData> notInPayCenterRefundList = new ArrayList<>();
            for (WxPayBillData wxTradeBillData: refundBillDataList) {
                String merchantRefundOrderNo = wxTradeBillData.getMerchantRefundOrderNo();
                String refundAmount = wxTradeBillData.getRefundAmount();
                wxRefundAmount = wxRefundAmount.add(new BigDecimal(refundAmount));
                boolean flag = false;

                for (Map<String, Object> map: refundOrderList) {
                    if (StringUtils.equals(map.get("refund_order_id").toString(), merchantRefundOrderNo)
                            && StringUtils.equals(map.get("refund_amount").toString(), refundAmount)) {
                        flag = true;
                    }
                }

                if (!flag) {
                    notInPayCenterRefundList.add(wxTradeBillData);
                }
            }

            // 对比退款数据，支付中心有，但是微信商户后台没有
            BigDecimal payCenterRefundAmount = new BigDecimal(0);
            List<Map<String, Object>> notInWxRefundList = new ArrayList<>();
            for (Map<String, Object> map: refundOrderList) {
                String refundOrderId = map.get("refund_order_id").toString();
                String refundAmount = map.get("refund_amount").toString();
                payCenterRefundAmount = payCenterRefundAmount.add(new BigDecimal(refundAmount));
                boolean flag = false;
                for (WxPayBillData wxTradeBillData: refundBillDataList) {
                    if (StringUtils.equals(refundOrderId, wxTradeBillData.getMerchantRefundOrderNo())
                            && StringUtils.equals(refundAmount, wxTradeBillData.getRefundAmount())) {
                        flag = true;
                    }
                }

                if (!flag) {
                    notInWxRefundList.add(map);
                }
            }

            String text = "日期：" + billDate + "\n\n"
                    + "微信商户平台-交易金额：" + wxTradeAmount + "\n\n"
                    + "支付中心-微信交易金额：" + payCenterTradeAmount + "\n\n"
                    + "微信商户平台-退款金额：" + wxRefundAmount + "\n\n"
                    + "支付中心-微信退款金额：" + payCenterRefundAmount + "\n\n";

            if (wxTradeAmount.compareTo(payCenterTradeAmount) != 0) {
                int tradeErrorCount = notInPayCenterTradeList.size() + notInWxTradeList.size();
                text += "**交易异常数据：共" + tradeErrorCount + "条**\n\n";
                int index = 0;
                if (notInPayCenterTradeList.size() > 0) {
                    text += "微信商户平台有，支付中心没有的数据：\n\n";
                    for (WxPayBillData wxTradeBillData: notInPayCenterTradeList) {
                        if (index > 0) {
                            text += "> ----------------\n\n";
                        }
                        index += 1;
                        text += "> 交易时间：" + wxTradeBillData.getTradeTime() + "\n\n";
                        text += "> 微信订单号：" + wxTradeBillData.getWxOrderNo() + "\n\n";
                        text += "> 商户订单号：" + wxTradeBillData.getMerchantOrderNo() + "\n\n";
                        text += "> 订单金额：" + wxTradeBillData.getOrderAmount() + "\n\n";
                    }
                }
                if (notInWxTradeList.size() > 0) {
                    text += "支付中心有，微信商户平台没有的数据：\n\n";
                    for (Map<String, Object> map: notInWxTradeList) {
                        if (index > 0) {
                            text += "> ----------------\n\n";
                        }
                        index += 1;
                        text += "> 时间：" + map.get("updated_at").toString() + "\n\n";
                        text += "> 微信订单号：" + map.get("third_trade_no").toString() + "\n\n";
                        text += "> 商户订单号：" + map.get("call_flow_no").toString() + "\n\n";
                        text += "> 订单金额：" + map.get("amount").toString() + "\n\n";
                    }
                }
            }

            if (wxRefundAmount.compareTo(payCenterRefundAmount) != 0) {
                int refundErrorCount = notInWxRefundList.size() + notInPayCenterRefundList.size();
                text += "**退款异常数据：共" + refundErrorCount + "条**\n\n";
                int index = 0;
                if (notInPayCenterRefundList.size() > 0) {
                    text += "微信商户平台有，支付中心没有的数据：\n\n";
                    for (WxPayBillData wxPayBillData: notInPayCenterRefundList) {
                        if (index > 0) {
                            text += "> ----------------\n\n";
                        }
                        index += 1;
                        text += "> 时间：" + wxPayBillData.getTradeTime() + "\n\n";
                        text += "> 商户订单号：" + wxPayBillData.getMerchantOrderNo() + "\n\n";
                        text += "> 商户退款单号：" + wxPayBillData.getMerchantRefundOrderNo() + "\n\n";
                        text += "> 退款金额：" + wxPayBillData.getRefundAmount() + "\n\n";
                    }
                }
                if (notInWxRefundList.size() > 0) {
                    text += "支付中心有，微信商户平台没有的数据：\n\n";
                    for (Map<String, Object> map: notInWxRefundList) {
                        if (index > 0) {
                            text += "> ----------------\n\n";
                        }
                        index += 1;
                        text += "> 时间：" + map.get("updated_at").toString() + "\n\n";
                        text += "> 商户订单号：" + map.get("repay_order_id").toString() + "\n\n";
                        text += "> 商户退款单号：" + map.get("refund_order_id").toString() + "\n\n";
                        text += "> 订单金额：" + map.get("refund_amount").toString() + "\n\n";
                    }
                }
            }

            String mkMsg = DingdingUtils.buildMarkdownMsg("微信支付对账" + billDate, text, false);
            DingdingUtils.sendToDingding(mkMsg, reconciliationDingUrl);
        }
    }

    /**
     * 支付宝商户后台与支付中心数据对账
     */
//    @Scheduled(cron = "0 */5 * * * ?")
//    @Scheduled(cron = "0 0 13 ? * *")
    public void aliPayDailyReconciliation() throws AlipayApiException, IOException {
        if (scheduledTaskStart.equals("true")) {
            log.info("开始支付宝支付对账.");
            String aliPayOrderSql = "SELECT * FROM pay_channel_order " +
                    "WHERE updated_at > (SELECT DATE_SUB(CURDATE(), INTERVAL 1 DAY)) AND updated_at < CURDATE() " +
                    "AND pay_approach in (81, 84) " +
                    "AND pay_status = 3";

            String aliPayRefundSql = "SELECT * FROM refund_order " +
                    "WHERE updated_at > (SELECT DATE_SUB(CURDATE(), INTERVAL 1 DAY)) " +
                    "AND updated_at < CURDATE() " +
                    "AND channel_account_id = '87' " +
                    "AND refund_status = 4";

            List<Map<String, Object>> payOrderList = JdbcUtils.queryForList(DB_HOST, DB_PORT, USERNAME, PASSWORD, "vpayment_center", aliPayOrderSql);
            List<Map<String, Object>> refundOrderList = JdbcUtils.queryForList(DB_HOST, DB_PORT, USERNAME, PASSWORD, "vpayment_center", aliPayRefundSql);

            String billDate = DateUtils.convertDate(DateUtils.getBeforeDay(new Date(), 1), "yyyy-MM-dd");
            List<AliPayBillData> aliPayBillDataList = aliPayBillService.parseAliPayBillFile(aliPayBillService.downloadBillFile(billDate));

            List<AliPayBillData> aliPayTradeList = new ArrayList<>();
            List<AliPayBillData> aliPayRefundList = new ArrayList<>();;

            for (AliPayBillData aliPayBillData: aliPayBillDataList) {
                if (StringUtils.equals(aliPayBillData.getTradeType(), "交易")) {
                    aliPayTradeList.add(aliPayBillData);
                }
                if (StringUtils.equals(aliPayBillData.getTradeType(), "退款")) {
                    aliPayRefundList.add(aliPayBillData);
                }
            }

            // 对比交易数据，支付宝商户后台有，但是支付中心数据库中没有的数据列表
            BigDecimal aliTradeAmount = new BigDecimal(0);
            List<AliPayBillData> notInPayCenterTradeList = new ArrayList<>();
            for (AliPayBillData aliPayBillData: aliPayTradeList) {
                String merchantOrderNo = aliPayBillData.getMerchantOrderNo();
                String orderAmount = aliPayBillData.getOrderAmount();
                aliTradeAmount = aliTradeAmount.add(new BigDecimal(orderAmount));
                boolean flag = false;
                for (Map<String, Object> map: payOrderList) {
                    if (StringUtils.equals(map.get("call_flow_no").toString(), merchantOrderNo)
                            && StringUtils.equals(map.get("amount").toString(), orderAmount)) {
                        flag = true;
                    }
                }

                if (!flag) {
                    notInPayCenterTradeList.add(aliPayBillData);
                }
            }

            // 对比交易数据，支付中心有，但是支付宝商户后台没有
            BigDecimal payCenterTradeAmount = new BigDecimal(0);
            List<Map<String, Object>> notInAliTradeList = new ArrayList<>();
            for (Map<String, Object> map: payOrderList) {
                String callFlowNo = map.get("call_flow_no").toString();
                String amount = map.get("amount").toString();
                payCenterTradeAmount = payCenterTradeAmount.add(new BigDecimal(amount));
                boolean flag = false;
                for (AliPayBillData aliPayBillData: aliPayTradeList) {
                    if (StringUtils.equals(callFlowNo, aliPayBillData.getMerchantOrderNo())
                            && StringUtils.equals(amount, aliPayBillData.getOrderAmount())) {
                        flag = true;
                    }
                }

                if (!flag) {
                    notInAliTradeList.add(map);
                }
            }

            // 对比退款数据，支付宝商户后台有，但是支付中心数据库中没有的数据列表
            BigDecimal aliRefundAmount = new BigDecimal(0);
            List<AliPayBillData> notInPayCenterRefundList = new ArrayList<>();
            for (AliPayBillData aliPayBillData: aliPayRefundList) {
                String merchantRefundOrderNo = aliPayBillData.getRefundOrderNo();
                String refundAmount = aliPayBillData.getOrderAmount();
                aliRefundAmount = aliRefundAmount.add(new BigDecimal(refundAmount));
                boolean flag = false;

                for (Map<String, Object> map: refundOrderList) {
                    if (StringUtils.equals(map.get("refund_order_id").toString(), merchantRefundOrderNo)
                            && StringUtils.equals(map.get("refund_amount").toString(), refundAmount)) {
                        flag = true;
                    }
                }

                if (!flag) {
                    notInPayCenterRefundList.add(aliPayBillData);
                }
            }

            // 对比退款数据，支付中心有，但是支付宝商户后台没有
            BigDecimal payCenterRefundAmount = new BigDecimal(0);
            List<Map<String, Object>> notInAliRefundList = new ArrayList<>();
            for (Map<String, Object> map: refundOrderList) {
                String refundOrderId = map.get("refund_order_id").toString();
                String refundAmount = map.get("refund_amount").toString();
                payCenterRefundAmount = payCenterRefundAmount.add(new BigDecimal(refundAmount));
                boolean flag = false;
                for (AliPayBillData aliPayBillData: aliPayRefundList) {
                    if (StringUtils.equals(refundOrderId, aliPayBillData.getRefundOrderNo())
                            && StringUtils.equals(refundAmount, aliPayBillData.getOrderAmount())) {
                        flag = true;
                    }
                }

                if (!flag) {
                    notInAliRefundList.add(map);
                }
            }

            String text = "日期：" + billDate + "\n\n"
                    + "支付宝商户平台-交易金额：" + aliTradeAmount + "\n\n"
                    + "支付中心-支付宝交易金额：" + payCenterTradeAmount + "\n\n"
                    + "支付宝商户平台-退款金额：" + aliRefundAmount + "\n\n"
                    + "支付中心-支付宝退款金额：" + payCenterRefundAmount + "\n\n";

            if (aliTradeAmount.compareTo(payCenterTradeAmount) != 0) {
                int tradeErrorCount = notInPayCenterTradeList.size() + notInAliTradeList.size();
                text += "**交易异常数据：共" + tradeErrorCount + "条**\n\n";
                int index = 0;
                if (notInPayCenterTradeList.size() > 0) {
                    text += "支付宝平台有，支付中心没有的数据：\n\n";
                    for (AliPayBillData aliPayBillData: notInPayCenterTradeList) {
                        if (index > 0) {
                            text += "> ----------------\n\n";
                        }
                        index += 1;
                        text += "> 交易时间：" + aliPayBillData.getTradeTime() + "\n\n";
                        text += "> 支付宝订单号：" + aliPayBillData.getAliPayTradeNo() + "\n\n";
                        text += "> 商户订单号：" + aliPayBillData.getMerchantOrderNo() + "\n\n";
                        text += "> 订单金额：" + aliPayBillData.getOrderAmount() + "\n\n";
                    }
                }
                if (notInAliTradeList.size() > 0) {
                    text += "支付中心有，支付宝平台没有的数据：\n\n";
                    for (Map<String, Object> map: notInAliTradeList) {
                        if (index > 0) {
                            text += "> ----------------\n\n";
                        }
                        index += 1;
                        text += "> 时间：" + map.get("updated_at").toString() + "\n\n";
                        text += "> 支付宝订单号：" + map.get("third_trade_no").toString() + "\n\n";
                        text += "> 商户订单号：" + map.get("call_flow_no").toString() + "\n\n";
                        text += "> 订单金额：" + map.get("amount").toString() + "\n\n";
                    }
                }
            }

            if (aliRefundAmount.compareTo(payCenterRefundAmount) != 0) {
                int refundErrorCount = notInAliRefundList.size() + notInPayCenterRefundList.size();
                text += "**退款异常数据：共" + refundErrorCount + "条**\n\n";
                int index = 0;
                if (notInPayCenterRefundList.size() > 0) {
                    text += "支付宝平台有，支付中心没有的数据：\n\n";
                    for (AliPayBillData aliPayBillData: notInPayCenterRefundList) {
                        if (index > 0) {
                            text += "> ----------------\n\n";
                        }
                        index += 1;
                        text += "> 时间：" + aliPayBillData.getTradeTime() + "\n\n";
                        text += "> 商户订单号：" + aliPayBillData.getMerchantOrderNo() + "\n\n";
                        text += "> 商户退款单号：" + aliPayBillData.getRefundOrderNo() + "\n\n";
                        text += "> 退款金额：" + aliPayBillData.getOrderAmount() + "\n\n";
                    }
                }
                if (notInAliRefundList.size() > 0) {
                    text += "支付中心有，支付宝平台没有的数据：\n\n";
                    for (Map<String, Object> map: notInAliRefundList) {
                        if (index > 0) {
                            text += "> ----------------\n\n";
                        }
                        index += 1;
                        text += "> 时间：" + map.get("updated_at").toString() + "\n\n";
                        text += "> 商户订单号：" + map.get("repay_order_id").toString() + "\n\n";
                        text += "> 商户退款单号：" + map.get("refund_order_id").toString() + "\n\n";
                        text += "> 订单金额：" + map.get("refund_amount").toString() + "\n\n";
                    }
                }
            }

            String mkMsg = DingdingUtils.buildMarkdownMsg("支付宝对账" + billDate, text, false);
            DingdingUtils.sendToDingding(mkMsg, reconciliationDingUrl);
        }
    }

}
