package cn.qg.holmes.controller.mock.keystone.jdbuy;

import cn.qg.holmes.bean.KeystoneService;
import cn.qg.holmes.entity.mock.keystone.*;
import cn.qg.holmes.entity.mock.keystone.jdbuy.JdFreightRequest;
import cn.qg.holmes.entity.mock.keystone.jdbuy.JdSellPriceRequest;
import cn.qg.holmes.entity.mock.keystone.jdbuy.JdSkuStateRequest;
import cn.qg.holmes.entity.mock.keystone.jdbuy.JdSkuStockRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商品相关mock接口
 * @author libo
 */
@Slf4j
@RestController
public class ProductController {

    @Autowired
    KeystoneService keystoneService;

    /**
     * 4.5 查询商品上下架状态
     * @param request
     * @return
     */
    @PostMapping("/api/product/skuState")
    public JSONObject getProductState(JdSkuStateRequest request) {
        JSONObject response = new JSONObject();
        String[] skuArray = request.getSku().split(",");
        response.put("success", true);
        response.put("resultMessage", "操作成功");
        response.put("resultCode", "0000");
        JSONArray jsonArray = new JSONArray();
        for (String sku : skuArray) {
            JSONObject skuObject = new JSONObject();
            skuObject.put("sku", Long.valueOf(sku));
            skuObject.put("state", 1);
            jsonArray.add(skuObject);
        }
        response.put("result", jsonArray);
        return response;
    }

    /**
     * 4.7 查询商品区域购买限制
     */
    @PostMapping("/api/product/checkAreaLimit")
    public JSONObject checkAreaLimit(String skuIds, String province, String city, String county, String town) {
        JSONObject response = new JSONObject();
        response.put("success", true);
        response.put("resultMessage", "");
        response.put("resultCode", "0000");

        JSONArray result = new JSONArray();
        if (!StringUtils.isEmpty(skuIds)) {
            String[] skuIdList = skuIds.split(",");
            for (String skuId: skuIdList) {
                JSONObject sku = new JSONObject();
                sku.put("skuId", skuId);
                sku.put("isAreaRestrict", false);

                result.add(sku);
            }
        }
        response.put("result", result);
        return response;
    }


    /**
     * 5.1 查询商品售卖价
     */
    @PostMapping("/api/price/getSellPrice")
    public JSONObject getSellPrice(JdSellPriceRequest request) {
        String[] skuArray = request.getSku().split(",");
        String queryExts = request.getQueryExts();
        JSONObject response = new JSONObject();
        response.put("success", true);
        response.put("resultMessage", "价格为null或者小于0时，为暂无报价");
        response.put("resultCode", "0000");
        JSONArray result = new JSONArray();
        for (String skuId: skuArray) {
            ProductItem productItem = keystoneService.getProductItemById(skuId, "jdbuy");
            JSONObject productJson = new JSONObject();
            productJson.put("skuId", Long.valueOf(skuId));
            productJson.put("jdPrice", productItem.getSupplyPrice());
            productJson.put("price", productItem.getSalePrice());
            if (queryExts != null && queryExts.contains("marketPrice")) {
                productJson.put("marketPrice", productItem.getMarketPrice());
            }
            if (queryExts != null && queryExts.contains("containsTax")) {
                // 随便模拟一个税率
                productJson.put("tax", 16);
                productJson.put("taxPrice", productItem.getSalePrice().multiply(new BigDecimal("0.16")));
                BigDecimal nakedPrice = productItem.getSalePrice().divide(new BigDecimal("1.16"), BigDecimal.ROUND_HALF_UP);
                productJson.put("nakedPrice", nakedPrice);
            }
            result.add(productJson);
        }
        response.put("result", result);
        return response;
    }

    /**
     * 6.1 查询商品库存
     * @return
     */
    @PostMapping("/api/stock/getNewStockById")
    public JSONObject getNewStockById(JdSkuStockRequest request) {
        JSONObject response = new JSONObject();
        JSONArray skuNumArray = JSON.parseArray(request.getSkuNums());
        List<JdSkuStockRequest.SkuNum> skuNumList = JSON.parseObject(skuNumArray.toJSONString(), new TypeReference<List<JdSkuStockRequest.SkuNum>>() {});
        String areaId = request.getArea();
        response.put("success", true);
        response.put("resultMessage", "");
        response.put("resultCode", "0000");
        JSONArray result = new JSONArray();
        for (JdSkuStockRequest.SkuNum skuNum: skuNumList) {
            JSONObject skuInfo = new JSONObject();
            skuInfo.put("skuId", skuNum.getSkuId());
            skuInfo.put("areaId", areaId);
            skuInfo.put("stockStateId", 33);
            skuInfo.put("StockStateDesc", "有货");
            skuInfo.put("remainNum", 100);

            result.add(skuInfo);
        }
        response.put("result", result);
        return response;
    }

    /**
     * 7.1 查询运费
     */
    @PostMapping("/api/order/getFreight")
    public JSONObject getOrderFreight(JdFreightRequest request) {
        JSONObject response = new JSONObject();
        response.put("success", true);
        response.put("resultMessage", "");
        response.put("resultCode", "0000");
        JSONObject result = new JSONObject();
        BigDecimal zero = new BigDecimal("0");
        result.put("freight", zero);
        result.put("baseFreight", zero);
        result.put("remoteRegionFreight", zero);
        result.put("remoteSku", "");
        response.put("result", result);
        return response;
    }

}
