package cn.qg.holmes.controller.quality;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.quality.SubmitTestInstruction;
import cn.qg.holmes.service.quality.SubmitTestInstructionService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 质量管理相关接口
 * @author libo
 * 2021-10-29
 */
@RestController
@RequestMapping("/quality")
public class QualityController {

    @Autowired
    SubmitTestInstructionService instructionService;

    @GetMapping("/testInstruction/list")
    public JsonResult getSubmitTestInstructionList(String projectName, String jiraProjectKey, Integer pageNum, Integer pageSize) {
        QueryWrapper<SubmitTestInstruction> queryWrapper = new QueryWrapper<>();
        if (!StringUtils.isEmpty(projectName)) {
            queryWrapper.eq("project_name", projectName);
        }
        if (!StringUtils.isEmpty(jiraProjectKey)) {
            queryWrapper.eq("jira_project_key", jiraProjectKey);
        }
        IPage<SubmitTestInstruction> instructionIPage = new Page<>(pageNum, pageSize);
        IPage<SubmitTestInstruction> page = instructionService.page(instructionIPage, queryWrapper);
        Map<String, Object> map = new HashMap<>();
        map.put("list", page.getRecords());
        map.put("total", page.getTotal());
        return JsonResult.buildSuccessResult(map);
    }

    @PostMapping("/testInstruction/save")
    public JsonResult saveSubmitTestInstruction(@RequestBody SubmitTestInstruction submitTestInstruction) {
        return null;
    }
}
