package cn.qg.holmes.entity.quality;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * 提测说明实体类
 * @author libo
 * 2021-10-29
 */
@Data
@TableName(value = "submit_test_instruction")
public class SubmitTestInstruction {

    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * jira项目关键字
     */
    private String jiraProjectKey;

    /**
     * 服务和分支
     */
    private String serviceAndBranch;

    /**
     * apollo配置
     */
    private String apollo;

    /**
     * 数据库变更
     */
    private String database;

    /**
     * 需求文档地址
     */
    private String requirement;

    /**
     * 接口文档地址
     */
    private String api;

    /**
     * 提测范围
     */
    private String scope;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
