package cn.qg.holmes.utils;

import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.client.JenkinsHttpClient;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.JobWithDetails;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Jenkins 相关操作工具类
 * @author libo
 */
@Component
public class JenkinsService {
    // Jenkins 对象
    private JenkinsServer jenkinsServer;
    // http 客户端对象
     private JenkinsHttpClient jenkinsHttpClient;

    // 连接 Jenkins 需要设置的信息
    static final String JENKINS_URL = "http://172.29.1.15:8080/";
    static final String JENKINS_USERNAME = "qahome";
    static final String JENKINS_PASSWORD = "Quantgroup123";

    /**
     * 构造方法中调用连接 Jenkins 方法
     */
    public JenkinsService() {
        // 连接 Jenkins
        try {
            jenkinsServer = new JenkinsServer(new URI(JENKINS_URL), JENKINS_USERNAME, JENKINS_PASSWORD);
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    /**
     * 构建jenkins job
     * @param type 服务类型：java/node/ui
     * @param project 项目名
     * @param branch 分支名
     * @param namespace 部署的环境
     * @return
     */
    public int buildJenkinsJob(String type, String project, String branch, String namespace) {
        Map<String, String> buildParams = new HashMap<>();
        buildParams.put("GIT_REPO", project);
        buildParams.put("BRANCH_NAME", branch);
        buildParams.put("DEPLOY", "true");
        buildParams.put("NAMESPACE", namespace);
        try {
            jenkinsServer.getJob("tke-" + type).build(buildParams);
            Build build = jenkinsServer.getJob("tke-" + type).getLastBuild();
            return build.getNumber() + 1;
        } catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    /**
     * 根据job名称获取job信息
     */
    public JobWithDetails getJobInfoByName(String jobName) {
        try {
            JobWithDetails job = jenkinsServer.getJob(jobName);
            return job;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 获取job列表
     * @return
     */
    public List<Map<String, String>> getJobList() {
        try {
            Map<String, Job> jobs = jenkinsServer.getJobs();
            List<Map<String, String>> jobList = new ArrayList<>();
            for (Job job:jobs.values()){
                Map<String, String> map = new HashMap<>();
                map.put("value", job.getName());
                map.put("label", job.getName());
                jobList.add(map);
            }
            return jobList;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 获取Job Build列表
     */
    public List<Build> getJobBuildList(String jobName, Integer num) {
        try {
            // 获取 Job 信息
            JobWithDetails job = jenkinsServer.getJob(jobName);
            // 获取全部 Build 信息
            Build lastBuild = job.getLastBuild();
            int lastBuildNumber = lastBuild.getNumber();
            List<Build> buildList = new ArrayList<>();
            for (int i = lastBuildNumber; i > lastBuildNumber - num; i--) {
                Build tempBuild = job.getBuildByNumber(i);
                if (tempBuild == null) {
                    return buildList;
                } else {
                    buildList.add(job.getBuildByNumber(i));
                }
            }
            return buildList;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 根据参数获取对应的build
     */
    public List<Build> getJobBuildList(String jobName, Integer num, String project) {
        try {
            // 获取 Job 信息
            JobWithDetails job = jenkinsServer.getJob(jobName);
            int lastBuildNumber = job.getLastBuild().getNumber();
            List<Build> buildList = new ArrayList<>();
            int caculator = 0;
            while (buildList.size() != num) {
                Build build = job.getBuildByNumber(lastBuildNumber - caculator);
                if (build == null) {
                    return buildList;
                }
                if (build.details().getParameters().get("GIT_REPO").equals(project)) {
                    buildList.add(build);
                }
                caculator += 1;
            }
            return buildList;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        JenkinsService jenkinsApi = new JenkinsService();
//        List<Build> buildList = jenkinsApi.getJobBuildList("tke-java", 1, "kdsp");
//        List<String> userList = new ArrayList<>();
//        for (Build build: buildList) {
//            System.out.println(build.details().getParameters().get("BRANCH_NAME"));
//            System.out.println(build.details().getParameters().get("NAMESPACE"));
//            System.out.println(build.details().getCauses().get(0).getUserName());
//            userList.add(build.details().getCauses().get(0).getUserName());
//            BuildResult buildResult = build.details().getResult();
//            System.out.println(buildResult);
//        }
//        System.out.println(userList.size());
        System.out.println(jenkinsApi.buildJenkinsJob("ui", "qa-platform-ui", "xiaotong", "fe"));
    }
}

