package cn.qg.holmes.controller.auth;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.auth.Role;
import cn.qg.holmes.entity.auth.RolePermission;
import cn.qg.holmes.entity.auth.RolePermissionVo;
import cn.qg.holmes.service.auth.RolePermissionService;
import cn.qg.holmes.service.auth.RoleService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.api.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@CrossOrigin
@RestController
@RequestMapping("/role/permission")
public class RolePermissionController {

    @Autowired
    RolePermissionService rolePermissionService;

    @Autowired
    RoleService roleService;

    /**
     * 新增角色权限
     * @return
     */
    @PostMapping("/add")
    public JsonResult addRolePermission(@RequestBody RolePermissionVo rolePermissionVo) {
        String roleName = rolePermissionVo.getRoleName();
        List<Integer> permissionIdList = rolePermissionVo.getPermissionIdList();
        QueryWrapper<Role> roleQueryWrapper = new QueryWrapper<>();
        roleQueryWrapper.eq("role_name", roleName);
        if (roleService.getOne(roleQueryWrapper) != null) {
            return JsonResult.buildErrorStateResult("角色名已存在！", false);
        }
        Role role = new Role();
        role.setRoleName(rolePermissionVo.getRoleName());
        boolean result = roleService.save(role);
        if (!result) {
            return JsonResult.buildErrorStateResult("新建角色失败！", false);
        }
        Role newRole = roleService.getOne(roleQueryWrapper);
        Integer roleId = newRole.getId();

        List<RolePermission> rolePermissionList = new ArrayList<>();
        for (Integer permissionId: permissionIdList) {
            RolePermission rolePermission = new RolePermission();
            rolePermission.setRoleId(roleId);
            rolePermission.setPermissionId(permissionId);
            rolePermissionList.add(rolePermission);
        }
        return JsonResult.buildSuccessResult(rolePermissionService.saveBatch(rolePermissionList));
    }

    /**
     * 编辑角色权限
     * @return
     */
    @PostMapping("/edit")
    public JsonResult editRolePermission(@RequestBody RolePermissionVo rolePermissionVo) {
        Integer roleId = rolePermissionVo.getRoleId();
        String roleName = rolePermissionVo.getRoleName();
        Role role = new Role();
        role.setId(roleId);
        role.setRoleName(roleName);
        boolean editRoleResult = roleService.saveOrUpdate(role);
        if (!editRoleResult) {
            return JsonResult.buildErrorStateResult("修改角色失败！", false);
        }
        try {
            QueryWrapper<RolePermission> rolePermissionQueryWrapper = new QueryWrapper<>();
            rolePermissionQueryWrapper.eq("role_id", roleId);
            // 先查出数据库里有哪些
            List<RolePermission> rolePermissionListInDB = rolePermissionService.list(rolePermissionQueryWrapper);
            List<Integer> permissionIdList = rolePermissionVo.getPermissionIdList();
            // 循环删除需要删除的
            for (RolePermission rolePermission: rolePermissionListInDB) {
                if (!permissionIdList.contains(rolePermission.getPermissionId())) {
                    rolePermissionService.removeById(rolePermission.getId());
                }
            }
            rolePermissionQueryWrapper.clear();
            // 然后处理需要新增或修改的
            for (Integer permissionId: permissionIdList) {
                rolePermissionQueryWrapper.eq("role_id", roleId);
                rolePermissionQueryWrapper.eq("permission_id", permissionId);
                RolePermission rolePermission = rolePermissionService.getOne(rolePermissionQueryWrapper);
                if (rolePermission == null) {
                    rolePermission = new RolePermission();
                    rolePermission.setRoleId(roleId);
                    rolePermission.setPermissionId(permissionId);
                    rolePermissionService.saveOrUpdate(rolePermission);
                } else {
                    rolePermission.setRoleId(roleId);
                    rolePermission.setPermissionId(permissionId);
                    rolePermissionService.saveOrUpdate(rolePermission);
                }
                rolePermissionQueryWrapper.clear();
            }
            return JsonResult.buildSuccessResult(true);
        } catch (Exception e) {
            e.printStackTrace();
            return JsonResult.buildErrorStateResult("角色权限分配失败！", false);
        }
    }

    /**
     * 删除角色以及角色对应权限
     * @param roleId 角色id
     * @return
     */
    @GetMapping("/del")
    public JsonResult delRolePermission(Integer roleId) {
        try {
            roleService.removeById(roleId);
            QueryWrapper<RolePermission> rolePermissionQueryWrapper = new QueryWrapper<>();
            rolePermissionQueryWrapper.eq("role_id", roleId);
            List<RolePermission> rolePermissionList = rolePermissionService.list(rolePermissionQueryWrapper);
            for (RolePermission rolePermission: rolePermissionList) {
                rolePermissionService.removeById(rolePermission.getId());
            }
            return JsonResult.buildSuccessResult(true);
        } catch (Exception e) {
            e.printStackTrace();
            return JsonResult.buildErrorStateResult("角色删除失败！", false);
        }
    }
}
