package cn.qg.holmes.utils;

import cn.qg.holmes.entity.k8s.DockerProject;
import cn.qg.holmes.service.k8s.DockerProjectService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabBranch;
import org.gitlab.api.models.GitlabProject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class GitlabService {

    @Autowired
    DockerProjectService dockerProjectService;

    private static final String GITABC_URL = "http://gitabc.xyqb.com/";
    private static final String GITABC_TOKEN = "XkBv7zaxnX_ag8mHBuN8";
    private static final String URL = "http://git.quantgroup.cn/";
    private static final String TOKEN = "owKJZwenxNaypTAz4Zcd";
    private static final String TJZIMU_URL = "https://gitlab.tjzimu.com/";
    private static final String TJZIMU_TOKEN = "jDqS5EHHzpGsn8J1aCUG";
    private GitlabAPI gitabcAPI;
    private GitlabAPI gitlabAPI;
    private GitlabAPI tjzimuGitlabAPI;

    public GitlabService() {
        try {
//            gitabcAPI = GitlabAPI.connect(GITABC_URL, GITABC_TOKEN);
            gitlabAPI = GitlabAPI.connect(URL, TOKEN);
//            tjzimuGitlabAPI = GitlabAPI.connect(TJZIMU_URL, TJZIMU_TOKEN);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取所有的项目
     * @return
     */
    public List<Map<String, Object>> getProjectList() {
        List<GitlabProject> gitlabProjectList = gitlabAPI.getProjects();
        List<Map<String, Object>> projectMapList = new ArrayList<>();
        for (GitlabProject gitlabProject: gitlabProjectList) {
            Map<String, Object> map = new HashMap<>();
            map.put("id", gitlabProject.getId());
            map.put("name", gitlabProject.getName());
            projectMapList.add(map);
        }
        return projectMapList;
    }

    public List<String> getBranchesByProjectName(String projectName) {
        List<Map<String, Object>> projectList = getProjectList();
        Integer projectId = null;
        for (Map<String, Object> map: projectList) {
            if (map.get("name").toString().equals(projectName)) {
                projectId = (Integer) map.get("id");
            }
        }
        List<GitlabBranch> gitlabBranchList = gitlabAPI.getBranches(projectId);
        List<String> branches = new ArrayList<>();
        for (GitlabBranch gitlabBranch: gitlabBranchList) {
            branches.add(gitlabBranch.getName());
        }
        return branches;
    }

    /**
     * 通过gitlab rest api获取项目列表
     * @param projectName 项目名称
     * @return
     */
    public List<Map<String, Object>> getProjectByRestApi(String projectName) {
        QueryWrapper<DockerProject> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_name", projectName);
        DockerProject dockerProject = dockerProjectService.getOne(queryWrapper);
        if (dockerProject == null) {
            return null;
        }
        String gitUrl = dockerProject.getGitPath();
        String gitHost = gitUrl.split("@")[1].split(":")[0];
        String apiVersion = "v4";  // 默认版本是v4
        String url = null;  // restapi url
        String result;   // 请求结果
        Map<String, String> params = new HashMap<>();
        params.put("per_page", "200");
        params.put("search", projectName);
        params.put("simple", "true");
        // gitabc.xyqb.com使用v3版本，git.quantgroup.cn和gitlab.tjzimu.com都使用v4版本
        if (gitHost.equals("gitabc.xyqb.com")) {
            apiVersion = "v3";
            url = GITABC_URL + "api/" + apiVersion + "/projects";
            params.put("private_token", GITABC_TOKEN);
        } else if (gitHost.equals("gitlab.git.quantgroup.cn")) {
            url = URL + "api/" + apiVersion + "/projects";
            params.put("private_token", TOKEN);
        } else if (gitHost.equals("gitlab.tjzimu.com")) {
            url = TJZIMU_URL + "api/" + apiVersion+ "/projects";
            params.put("private_token", TJZIMU_TOKEN);
        }
        if (url == null) {
            return null;
        }
        result = HttpClientUtils.doGet(url, params);
        return result == null ? null : (List<Map<String, Object>>) JSON.parse(result);
    }

    public List<Map> getBranchesByProjectId(String projectName, Integer projectId) {
        String url = URL + "api/v4/projects/" + projectId.toString() + "/repository/branches";
        String tjzimuUrl = TJZIMU_URL + "api/v4/projects/" + projectId.toString() + "/repository/branches";
        Map<String, String> params = new HashMap<>();
        List<Map> branchList = new ArrayList<>();
        params.put("per_page", "100");
        if (projectName.equals("xyqb-user3")) {
            params.put("private_token", TJZIMU_TOKEN);
        } else {
            params.put("private_token", TOKEN);
        }
        for (int i=0; i < 4; i++) {
            params.put("page", String.valueOf(i+1));
            String requestResult;
            if (projectName.equals("xyqb-user3")) {
                requestResult = HttpClientUtils.doGet(tjzimuUrl, params);
            } else {
                requestResult = HttpClientUtils.doGet(url, params);
            }
            branchList.addAll(JSONArray.parseArray(requestResult, Map.class));
        }
        return branchList;
    }

    /**
     * 通过gitlab rest api 获取项目分支
     * @param projectName
     * @return
     */
    public List<Map> getBranchesByProjectNameByRestApi(String projectName) {
        try {
            QueryWrapper<DockerProject> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("project_name", projectName);
            DockerProject dockerProject = dockerProjectService.getOne(queryWrapper);
            if (dockerProject == null) {
                return null;
            }
            String gitUrl = dockerProject.getGitPath();
            String gitHost = gitUrl.split("@")[1].split(":")[0];
            String projectPath = gitUrl.split(":")[1].split("\\.")[0];
            String encodeProjectPath = URLEncoder.encode(projectPath, "utf8");
            String apiVersion = "v4";
            String url = null;
            String result;
            Map<String, String> headers = new HashMap<>();
            Map<String, String> params = new HashMap<>();
            int initPage = 1;
            params.put("per_page", "100");
            switch (gitHost) {
                case "gitabc.xyqb.com":
                    apiVersion = "v3";
                    url = GITABC_URL + "api/" + apiVersion + "/projects/" + encodeProjectPath + "/repository/branches";
                    headers.put("PRIVATE-TOKEN", GITABC_TOKEN);
                    break;
                case "git.quantgroup.cn":
                    url = URL + "api/" + apiVersion + "/projects/" + encodeProjectPath + "/repository/branches";
                    headers.put("PRIVATE-TOKEN", TOKEN);
                    break;
                case "gitlab.tjzimu.com":
                    url = TJZIMU_URL + "api/" + apiVersion + "/projects/" + encodeProjectPath + "/repository/branches";
                    headers.put("PRIVATE-TOKEN", TJZIMU_TOKEN);
                    break;
            }
            if (url == null) {
                return null;
            }
            List<Map> resultList = new ArrayList<>();
            // 目的是在不确定分支数量的情况下获取所有分支
            while (true) {
                params.put("page", String.valueOf(initPage));
                result = HttpClientUtils.doGet(url, headers, params);
                if (result == null) {
                    return null;
                }
                List<Map> tempList = (List<Map>) JSON.parse(result);
                resultList.addAll(tempList);
                if (tempList.size() == 100) {
                    initPage += 1;
                } else {
                    break;
                }
            }
            return resultList;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

}
