package cn.qg.holmes.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.models.GitlabBranch;
import org.gitlab.api.models.GitlabProject;
import org.springframework.stereotype.Component;

import java.util.*;

@Component
public class GitlabService {

    private static final String URL = "http://git.quantgroup.cn/";

    private static final String TOKEN = "owKJZwenxNaypTAz4Zcd";

    private GitlabAPI gitlabAPI;

    public GitlabService() {
        try {
            gitlabAPI = GitlabAPI.connect(URL, TOKEN);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取所有的项目
     * @return
     */
    public List<Map<String, Object>> getProjectList() {
        List<GitlabProject> gitlabProjectList = gitlabAPI.getProjects();
        List<Map<String, Object>> projectMapList = new ArrayList<>();
        for (GitlabProject gitlabProject: gitlabProjectList) {
            Map<String, Object> map = new HashMap<>();
            map.put("id", gitlabProject.getId());
            map.put("name", gitlabProject.getName());
            projectMapList.add(map);
        }
        return projectMapList;
    }

    public List<String> getBranchesByProjectName(String projectName) {
        List<Map<String, Object>> projectList = getProjectList();
        Integer projectId = null;
        for (Map<String, Object> map: projectList) {
            if (map.get("name").toString().equals(projectName)) {
                projectId = (Integer) map.get("id");
            }
        }
        List<GitlabBranch> gitlabBranchList = gitlabAPI.getBranches(projectId);
        List<String> branches = new ArrayList<>();
        for (GitlabBranch gitlabBranch: gitlabBranchList) {
            branches.add(gitlabBranch.getName());
        }
        return branches;
    }

    public List<Map<String, Object>> getProjectByRestApi(String projectName) {
        String url = URL + "api/v4/projects";
        Map<String, String> params = new HashMap<>();
        params.put("per_page", "200");
        params.put("search", projectName);
        params.put("private_token", TOKEN);
        params.put("simple", "true");
        String result = HttpClientUtils.doGet(url, params);
        return (List<Map<String, Object>>) JSON.parse(result);
    }

    public List<Map> getBranchesByProjectId(Integer projectId) {
        String url = URL + "api/v4/projects/" + projectId.toString() + "/repository/branches";
        Map<String, String> params = new HashMap<>();
        List<Map> branchList = new ArrayList<>();
        params.put("per_page", "100");
        params.put("private_token", TOKEN);
        for (int i=0; i < 4; i++) {
            params.put("page", String.valueOf(i+1));
            String requestResult = HttpClientUtils.doGet(url, params);
            branchList.addAll(JSONArray.parseArray(requestResult, Map.class));
        }
        return branchList;
    }


    public static void main(String[] args) {
        GitlabService gitlabService = new GitlabService();
//        List<String> branches = gitlabService.getBranchesByProjectName("holmes");
//        System.out.println(branches);
//        System.out.println(gitlabService.getProjectByRestApi("holmes"));
        System.out.println(gitlabService.getBranchesByProjectId(795).size());
    }

}
