package cn.qg.holmes.controller.auth;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.config.annotation.RequiresPermissions;
import cn.qg.holmes.entity.auth.UserRole;
import cn.qg.holmes.service.auth.UserRoleService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin
@RestController
@RequestMapping("/user/role")
public class UserRoleController {

    @Autowired
    UserRoleService userRoleService;

    /**
     * 用户新增角色
     * @param userId 用户id
     * @param roleId 角色id
     * @return
     */
    @RequiresPermissions("user:role:add")
    @PostMapping("/add")
    public JsonResult addUserRole(Integer userId, Integer roleId) {
        QueryWrapper<UserRole> userRoleQueryWrapper = new QueryWrapper<>();
        userRoleQueryWrapper.eq("user_id", userId);
        userRoleQueryWrapper.eq("role_id", roleId);
        if (userRoleService.getOne(userRoleQueryWrapper) != null) {
            return JsonResult.buildErrorStateResult("用户角色已存在！", false);
        }
        userRoleQueryWrapper.clear();
        userRoleQueryWrapper.eq("user_id", userId);
        UserRole userRole = userRoleService.getOne(userRoleQueryWrapper);
        if (userRole == null) {
            UserRole newUserRole = new UserRole();
            newUserRole.setUserId(userId);
            newUserRole.setRoleId(roleId);
            return JsonResult.buildSuccessResult(userRoleService.save(newUserRole));
        } else {
            userRole.setRoleId(roleId);
            return JsonResult.buildSuccessResult(userRoleService.saveOrUpdate(userRole));
        }
    }

    /**
     * 编辑用户角色权限
     * @param userRole 用户角色实体
     * @return
     */
    @RequiresPermissions("user:role:edit")
    @PostMapping("/edit")
    public JsonResult editUserRole(UserRole userRole) {
        return JsonResult.buildSuccessResult(userRoleService.updateById(userRole));
    }
}
