package cn.qg.holmes.controller.effect;

import cn.qg.holmes.common.JsonResult;
import cn.qg.holmes.entity.effect.ClearCache;
import cn.qg.holmes.entity.quality.DingRobot;
import cn.qg.holmes.entity.quality.JiraBugPool;
import cn.qg.holmes.entity.quality.SubmitTestInstruction;
import cn.qg.holmes.service.effect.ClearCacheService;
import cn.qg.holmes.service.quality.DingRobotService;
import cn.qg.holmes.service.quality.JiraBugPoolService;
import cn.qg.holmes.service.quality.SubmitTestInstructionService;
import cn.qg.holmes.utils.HttpClientUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.xml.transform.Result;
import java.util.*;

@Slf4j
@CrossOrigin
@RestController
@RequestMapping("/effect")
public class EffectController {

    @Autowired
    ClearCacheService clearCacheService;

    @Autowired
    DingRobotService dingRobotService;

    @Autowired
    SubmitTestInstructionService submitTestInstructionService;

    @Autowired
    JiraBugPoolService jiraBugPoolService;

    /**
     * 获取清缓存实体列表
     * @return
     */
    @GetMapping("/cacheList")
    public JsonResult getCacheList() {
        return JsonResult.buildSuccessResult(clearCacheService.list());
    }

    /**
     * 清缓存
     * @param id 缓存id
     * @param namespace 环境
     * @return
     */
    @GetMapping("/clearcache")
    public JsonResult clearCache(Integer id, String namespace) {
        ClearCache clearCache = clearCacheService.getById(id);
        String url = clearCache.getUrl();
        if (url.contains("{NAMESPACE}")) {
            if (StringUtils.isEmpty(namespace)) {
                return JsonResult.buildErrorStateResult("请先选择环境！", false);
            } else {
                url = url.replace("{NAMESPACE}", namespace);
            }
        }
        String result = HttpClientUtils.doGet(url);
        return JsonResult.buildSuccessResult(JSON.parseObject(result, Map.class));
    }

    @GetMapping("/qa/transfer")
    public JsonResult transferData() {
        String doraemonUrl = "https://doraemon.quantgroups.cn/qa/process/transfer";
        QueryWrapper<DingRobot> queryWrapper = new QueryWrapper<>();
        queryWrapper.orderByAsc("id");
        List<DingRobot> dingRobotList = dingRobotService.list(queryWrapper);
        for (DingRobot dingRobot: dingRobotList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("projectName", dingRobot.getProjectName());
            String jiraKey = dingRobot.getJiraProjectKey();
            // 1-toc, 2-tob, 3-金融，4-大数据
            int bizLineId;
            switch (jiraKey) {
                case "YXM":
                case "GYL":
                case "DDMPT":
                    bizLineId = 1;
                    break;
                case "SAAS":
                    bizLineId = 2;
                    break;
                case "KA":
                case "ZF":
                    bizLineId = 3;
                    break;
                case "BD":
                case "DATA":
                    bizLineId = 4;
                    break;
                default:
                    bizLineId = 1;
                    break;
            }
            jsonObject.put("businessLineId", bizLineId);
            jsonObject.put("jiraKey", jiraKey);
            jsonObject.put("dingUrl", dingRobot.getDingUrl());
            Integer insId = dingRobot.getSubmitTestInstructionId();
            if (insId != null) {
                SubmitTestInstruction testInstruction = submitTestInstructionService.getById(insId);
                if (testInstruction != null) {
                    // 服务与分支
                    List<Map<String, String>> newMapList = new ArrayList<>();
                    String serviceAndBranch = testInstruction.getServiceAndBranch();
                    if (!StringUtils.isEmpty(serviceAndBranch)) {
                        List<Map<String, String>> mapList = JSON.parseObject(serviceAndBranch, List.class);
                        for (Map<String, String> map: mapList) {
                            Map<String, String> newMap = new HashMap<>();
                            newMap.put("serviceName", map.get("serviceName"));
                            newMap.put("branchName", map.get("branch"));
                            newMap.put("developer", map.get("developer"));
                            newMapList.add(newMap);
                        }
                    }
                    jsonObject.put("serviceAndBranchList", newMapList);

                    // apollo
                    Map<String, Object> apolloMap = new HashMap<>();
                    String apollo = testInstruction.getApollo();
                    if (!StringUtils.isEmpty(apollo)) {
                        List<Map<String, String>> oldApolloList = JSON.parseObject(apollo, List.class);
                        for (Map<String, String> map: oldApolloList) {
                            String projectName = map.get("projectName");
                            if (apolloMap.containsKey(projectName)) {
                                List<Map<String, String>> alreadyList = (List<Map<String, String>>) apolloMap.get(projectName);
                                Map<String, String> tempMap = new HashMap<>();
                                tempMap.put("key", map.get("key"));
                                tempMap.put("value", map.get("value"));
                                alreadyList.add(tempMap);
                                apolloMap.put(projectName, alreadyList);
                            } else {
                                List<Map<String, String>> newList = new ArrayList<>();
                                Map<String, String> tempMap = new HashMap<>();
                                tempMap.put("key", map.get("key"));
                                tempMap.put("value", map.get("value"));
                                newList.add(tempMap);
                                apolloMap.put(projectName, newList);
                            }
                        }
                    }
                    jsonObject.put("apolloUpdate", apolloMap);

                    // 数据库
                    StringBuilder sb = new StringBuilder();
                    String database = testInstruction.getDatabase();
                    if (!StringUtils.isEmpty(database)) {
                        List<Map<String, String>> dbList = JSON.parseObject(database, List.class);
                        for (Map<String, String> map: dbList) {
                            sb.append(map.get("sql"));
                            sb.append("\n");
                        }
                    }
                    jsonObject.put("databaseUpdate", sb.toString());

                    jsonObject.put("prodDocument", testInstruction.getRequirement());
                    jsonObject.put("interfaceDocument", testInstruction.getApi());
                    jsonObject.put("remark", testInstruction.getScope());
                }
            }
            jsonObject.put("env", dingRobot.getNamespace());
            jsonObject.put("refuseNum", dingRobot.getRepulseNum());
            // 项目状态
            Integer oldStatus = dingRobot.getStatus();
            if (oldStatus == 1) {
                jsonObject.put("status", 1);
            } else if (oldStatus == 2) {
                jsonObject.put("progress", 100D);
                jsonObject.put("status", 3);
            } else {
                jsonObject.put("progress", 100D);
                jsonObject.put("status", 3);
            }
            jsonObject.put("creator", dingRobot.getCreator());

            String response = HttpClientUtils.doPostJson(doraemonUrl, null, jsonObject.toJSONString());
            log.info(response);
        }
        return JsonResult.buildSuccessResult("trasnfer成功");
    }

    @GetMapping("/bug/transfer")
    public JsonResult bugTransfer() {
        String doraemonUrl = "https://doraemon.quantgroups.cn/qa/bug/transfer";
//        String doraemonUrl = "http://localhost:8086/qa/bug/transfer";
        QueryWrapper<JiraBugPool> queryWrapper = new QueryWrapper<>();
        queryWrapper.orderByAsc("id");
        List<JiraBugPool> jiraBugPoolList = jiraBugPoolService.list(queryWrapper);
        for (JiraBugPool jiraBugPool: jiraBugPoolList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", jiraBugPool.getId());
            jsonObject.put("key", jiraBugPool.getKey());
            jsonObject.put("summary", jiraBugPool.getSummary());
            jsonObject.put("priority", jiraBugPool.getPriority());
            jsonObject.put("reporter", jiraBugPool.getReporter());
            jsonObject.put("assignee", jiraBugPool.getAssignee());
            jsonObject.put("url", jiraBugPool.getUrl());
            jsonObject.put("dingUrl", jiraBugPool.getDingUrl());
            jsonObject.put("processId", jiraBugPool.getDingRobotId());
            jsonObject.put("enable", jiraBugPool.getEnable());
            jsonObject.put("createTime", jiraBugPool.getCreateTime());
            jsonObject.put("updateTime", jiraBugPool.getUpdateTime());

            String response = HttpClientUtils.doPostJson(doraemonUrl, null, jsonObject.toJSONString());
            log.info(response);
        }
        return JsonResult.buildSuccessResult("bug数据清洗完毕");
    }
}
