package cn.qg.holmes.service.jira.impl;

import cn.qg.holmes.service.jira.JiraIssueService;
import cn.qg.holmes.utils.DingdingUtils;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClientFactory;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import io.atlassian.util.concurrent.Promise;
import org.springframework.stereotype.Service;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

@Service
public class JiraIssueServiceImpl implements JiraIssueService {

    public static String url = "http://jira2.quantgroup.cn/";
    public static String username = "test1";
    public static String password = "123456";

    public static JiraRestClient createJiraRestClient() {
        JiraRestClientFactory jiraRestClientFactory = new AsynchronousJiraRestClientFactory();
        JiraRestClient jiraRestClient = null;
        try {
            jiraRestClient = jiraRestClientFactory.createWithBasicHttpAuthentication(new URI(url), username, password);
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return jiraRestClient;
    }

    /**
     * 根据项目关键字获取未解决BUG列表
     * @param project 项目关键字，如"YXM"
     * @return
     * @throws Exception
     */
    @Override
    public Iterable<Issue> getUnsolvedIssueListByProject(String project) throws Exception{
        JiraRestClient jiraRestClient = createJiraRestClient();
        Promise<SearchResult> resultPromise =  jiraRestClient.getSearchClient().searchJql("project = " + project + " AND resolution = Unresolved ORDER BY priority DESC");
        Iterable<Issue> issues = resultPromise.get().getIssues();
        return issues;
    }

}
