package cn.qg.holmes.service.auth.impl;

import cn.qg.holmes.entity.auth.User;
import cn.qg.holmes.service.auth.LdapService;
import cn.qg.holmes.service.auth.LoginService;
import cn.qg.holmes.service.auth.UserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

import java.nio.charset.StandardCharsets;
import java.util.Map;

@Slf4j
@Service
public class LoginServiceImpl implements LoginService {
    @Autowired
    LdapService ldapService;

    @Autowired
    UserService userService;

    @Override
    public boolean login(String username, String password) {
        boolean result = ldapService.authenticate(username, password);
        log.info("登录结果为：{}", result);
        if (result) {
            Map<String, String> userInfo = ldapService.getUserInfo();
            User user = userService.getUserByUsername(username);
            // 用户不存在，则创建新用户
            if (user == null) {
                User newUser = new User();
                newUser.setUsername(username);
                newUser.setChineseName(userInfo.get("chineseName"));
                newUser.setEmail(userInfo.get("email"));
                newUser.setTitle(userInfo.get("title"));
                userService.save(newUser);
            }
        }
        return result;
    }
}
